<?php
	$settingValue = ( isset($this->settings['settings']['display_view_more']) ? (int) $this->settings['settings']['display_view_more'] : '' );
	$hiddenStyle = $settingValue ? '' : 'wpfHidden';
?>
<div class="row row-settings-block">
	<div class="settings-block-label col-xs-4 col-xl-3">
		<?php esc_html_e('Display "Show more"', 'woo-product-filter'); ?>
	</div>
	<div class="col-xs-2 col-sm-1">
		<i class="fa fa-question woobewoo-tooltip" title="<?php echo esc_attr__('For long vertical lists, "Show more" will be displayed.', 'woo-product-filter'); ?>"></i>
	</div>
	<div class="settings-block-values col-xs-6 col-sm-7 col-xl-8">
		<div class="settings-value">
			<?php
				HtmlWpf::checkboxToggle('settings[display_view_more]', array(
				'checked' => $settingValue
				));
				?>
		</div>
		<div class="settings-value <?php echo esc_attr($hiddenStyle); ?>" data-parent="settings[display_view_more]">
			<div class="settings-value-label">
				<?php esc_html_e('Full opening', 'woo-product-filter'); ?>
			</div>
			<?php
				HtmlWpf::checkboxToggle('settings[view_more_full]', array(
					'checked' => ( isset($this->settings['settings']['view_more_full']) ? (int) $this->settings['settings']['view_more_full'] : '' )
				));
				?>
		</div>
	</div>
</div>
<?php
	$settingValue = ( isset($this->settings['settings']['display_selected_params']) ? (int) $this->settings['settings']['display_selected_params'] : '' );
	$hiddenStyle = $settingValue ? '' : 'wpfHidden';
?>
<div class="row row-settings-block">
	<div class="settings-block-label col-xs-4 col-xl-3">
		<?php esc_html_e('Display selected parameters of filters', 'woo-product-filter'); ?>
	</div>
	<div class="col-xs-2 col-sm-1">
		<i class="fa fa-question woobewoo-tooltip" title="<?php echo esc_attr('<div class="woobewoo-tooltips-wrapper"><div class="woobewoo-tooltips-text">' . __('Selected parameters will be displayed in the top/bottom of the filter.', 'woo-product-filter') . '</div><img src="' . esc_url(FrameWpf::_()->getModule('woofilters')->getModPath() . 'img/display_selected_parameters_of_filters.png') . '" height="193"></div>'); ?>"></i>
	</div>
	<div class="settings-block-values col-xs-6 col-sm-7 col-xl-8">
		<div class="settings-value">
			<?php
				HtmlWpf::checkboxToggle('settings[display_selected_params]', array(
					'checked' => $settingValue
				));
				?>
		</div>
		<div class="settings-value <?php echo esc_attr($hiddenStyle); ?>" data-parent="settings[display_selected_params]">
			<?php
				HtmlWpf::selectbox('settings[selected_params_position]', array(
					'options' => array('top' => 'Top', 'bottom' => 'Bottom'),
					'value' => ( isset($this->settings['settings']['selected_params_position']) ? $this->settings['settings']['selected_params_position'] : 'top' ),
					'attrs' => 'class="woobewoo-flat-input"'
				));
				?>
		</div>
		<div class="settings-value <?php echo esc_attr($hiddenStyle); ?>" data-parent="settings[display_selected_params]">
			<div class="settings-value-label">
				<?php esc_html_e('Display "Clear All"', 'woo-product-filter'); ?>
			</div>
			<?php
				HtmlWpf::checkboxToggle('settings[selected_params_clear]', array(
					'checked' => ( isset($this->settings['settings']['selected_params_clear']) ? (int) $this->settings['settings']['selected_params_clear'] : '' )
				));
				?>
		</div>
		<div class="settings-value <?php echo esc_attr($hiddenStyle); ?>"  data-parent="settings[display_selected_params]">
			<div class="settings-value-label">
				<?php esc_html_e('Display child categories', 'woo-product-filter'); ?>
				<i class="fa fa-question woobewoo-tooltip" title="<?php echo esc_attr__('Display both of child and parent categories.', 'woo-product-filter'); ?>"></i>
			</div>
			<?php
				HtmlWpf::checkboxToggle('settings[expand_selected_to_child]', array(
					'checked' => ( isset($this->settings['settings']['expand_selected_to_child']) ? (int) $this->settings['settings']['expand_selected_to_child'] : 1 )
				));
				?>
		</div>
	</div>
</div>
