			<?php
				$hideButton = ( isset($this->settings['settings']['display_hide_button']) ? $this->settings['settings']['display_hide_button'] : 'no' );
				$hideMobileButton = ( isset($this->settings['settings']['display_hide_button_mobile']) ? $this->settings['settings']['display_hide_button_mobile'] : 'no' );
				$hideText = esc_attr__('HIDE FILTERS', 'woo-product-filter');
				$showText = esc_attr__('SHOW FILTERS', 'woo-product-filter');
				$hiddenStyle = 'no' == $hideButton && 'no' == $hideMobileButton ? 'wpfHidden' : '';
			?>
			
			<div class="row row-settings-block">
				<div class="settings-block-label col-xs-4 col-xl-3">
					<?php esc_html_e('Display Hide Filters button', 'woo-product-filter'); ?>
				</div>
				<div class="col-xs-2 col-sm-1">
				</div>
				<div class="settings-block-values col-xs-6 col-sm-7 col-xl-8">
					<div class="settings-value">
						<div class="settings-value-label woobewoo-width60">
							<?php esc_html_e('desktop', 'woo-product-filter'); ?>
						</div>
						<?php 
							HtmlWpf::selectbox('settings[display_hide_button]', array(
								'options' => array('no' => 'No', 'yes_close' => 'Yes, show as close', 'yes_open' => 'Yes, show as opened'),
								'value' => $hideButton,
								'attrs' => 'class="woobewoo-flat-input"'
							));
							?>
					</div>
					<div class="settings-value">
						<div class="settings-value-label woobewoo-width60">
							<?php esc_html_e('mobile', 'woo-product-filter'); ?>
						</div>
						<?php 
							HtmlWpf::selectbox('settings[display_hide_button_mobile]', array(
								'options' => array('no' => 'No', 'yes_close' => 'Yes, show as close', 'yes_open' => 'Yes, show as opened'),
								'value' => $hideMobileButton,
								'attrs' => 'class="woobewoo-flat-input"'
							));
							?>
					</div>
					<div class="clear"></div>
					<div class="settings-value <?php echo esc_attr($hiddenStyle); ?>">
						<div class="settings-value-label woobewoo-width60">
							<?php esc_html_e('hide', 'woo-product-filter'); ?>
						</div>
						<?php 
							HtmlWpf::text('settings[hide_button_hide_text]', array(
								'value' => ( isset($this->settings['settings']['hide_button_hide_text']) ? $this->settings['settings']['hide_button_hide_text'] : $hideText ),
								'attrs' => 'placeholder="' . esc_attr($hideText) . '" class="woobewoo-flat-input woobewoo-width150"'
							));
							?>
					</div>					
					<div class="settings-value <?php echo esc_attr($hiddenStyle); ?>">
						<div class="settings-value-label woobewoo-width60">
							<?php esc_html_e('show', 'woo-product-filter'); ?>
						</div>
						<?php 
							HtmlWpf::text('settings[hide_button_show_text]', array(
								'value' => ( isset($this->settings['settings']['hide_button_show_text']) ? $this->settings['settings']['hide_button_show_text'] : $showText ),
								'attrs' => 'placeholder="' . esc_attr($showText) . '" class="woobewoo-flat-input woobewoo-width150"'
							));
							?>
					</div>
				</div>
			</div>
