<?php
$tamplatePath = FrameWpf::_()->getModule('woofilters')->getView()->getPath('woofiltersEditTabCommonTitle');

// fallback for depricated optionality
if ( $tamplatePath ) {
	FrameWpf::_()->getModule('woofilters')->getView()->display('woofiltersEditTabCommonTitle');
} else {
	ViewWpf::display('woofiltersEditTabCommonTitleDepricated');
}
?>
<div class="row-settings-block">
	<div class="settings-block-label col-xs-4 col-sm-3">
		<?php esc_html_e('Use title as placeholder', 'woo-product-filter'); ?>
		<i class="fa fa-question woobewoo-tooltip no-tooltip" title="<?php echo esc_attr__('Set filter title as search input placeholder.', 'woo-product-filter'); ?>"></i>
	</div>
	<div class="settings-block-values col-xs-8 col-sm-9">
		<div class="settings-value">
			<?php HtmlWpf::checkboxToggle('f_title_as_placeholder', array()); ?>
		</div>
	</div>
</div>
<div class="row-settings-block">
	<div class="settings-block-label col-xs-4 col-sm-3">
		<?php esc_html_e('Search by', 'woo-product-filter'); ?>
		<i class="fa fa-question woobewoo-tooltip no-tooltip" title="<?php echo esc_attr__('Chose searching params', 'woo-product-filter'); ?>"></i>
	</div>
	<div class="sub-block-values col-xs-8 col-sm-9">
		<div class="settings-value">
			<?php HtmlWpf::checkboxToggle('f_search_by_title', array()); ?>
			<div class="settings-label-after">
				<?php esc_html_e('Title', 'woo-product-filter'); ?>
			</div>
		</div>
		<div class="settings-value">
			<?php HtmlWpf::checkboxToggle('f_search_by_content', array()); ?>
			<div class="settings-label-after">
				<?php esc_html_e('Content', 'woo-product-filter'); ?>
			</div>
		</div>
		<div class="settings-value">
			<?php HtmlWpf::checkboxToggle('f_search_by_excerpt', array()); ?>
			<div class="settings-label-after">
				<?php esc_html_e('Excerpt', 'woo-product-filter'); ?>
			</div>
		</div>
		<div class="settings-value">
			<?php HtmlWpf::checkboxToggle('f_search_by_attributes', array()); ?>
			<div class="settings-label-after">
				<?php esc_html_e('Attributes', 'woo-product-filter'); ?>
			</div>
		</div>
	</div>
</div>
<div class="row-settings-block">
	<div class="settings-block-label col-xs-4 col-sm-3">
		<?php esc_html_e('Logic', 'woo-product-filter'); ?>
	</div>
	<div class="settings-block-values col-xs-8 col-sm-9">
		<div class="settings-value">
			<?php 
				HtmlWpf::selectbox('f_query_logic', array(
					'options' => array('and' => 'And', 'or' => 'Or'),
					'value' => 'or',
					'attrs' => 'class="woobewoo-flat-input"'
				));
				?>
		</div>
	</div>
</div>
<div class="row-settings-block">
	<div class="settings-block-label col-xs-4 col-sm-3">
		<?php esc_html_e('Search by full word only', 'woo-product-filter'); ?>
		<i class="fa fa-question woobewoo-tooltip no-tooltip" title="<?php echo esc_attr__('Search only by full words only.', 'woo-product-filter'); ?>"></i>
	</div>
	<div class="settings-block-values col-xs-8 col-sm-9">
		<div class="settings-value">
			<?php HtmlWpf::checkboxToggle('f_search_only_by_full_word', array()); ?>
		</div>
	</div>
</div>
<div class="row-settings-block">
	<div class="settings-block-label col-xs-4 col-sm-3">
		<?php esc_html_e('Exclude from search results', 'woo-product-filter'); ?>
		<i class="fa fa-question woobewoo-tooltip no-tooltip" title="<?php echo esc_attr__('Exclude from search results selected items or items with selected taxonomies.', 'woo-product-filter'); ?>"></i>
	</div>
	<div class="settings-block-values col-xs-8 col-sm-9">
		<div class="settings-value woobewoo-width-full">
			<?php HtmlWpf::selectlist('f_mlist', array('size' => 10, 'options' => $this->excludedOptions)); ?>
		</div>
	</div>
</div>
<div class="row-settings-block">
	<div class="settings-block-label col-xs-4 col-sm-3">
		<?php esc_html_e('Autocomplete', 'woo-product-filter'); ?>
		<i class="fa fa-question woobewoo-tooltip no-tooltip" title="<?php echo esc_attr__('Autocomplete relevant variants. Works only when searching by title.', 'woo-product-filter'); ?>"></i>
	</div>
	<div class="settings-block-values col-xs-8 col-sm-9">
		<div class="settings-value">
			<?php HtmlWpf::checkboxToggle('f_search_autocomplete', array()); ?>
		</div>
	</div>
</div>
