<?php
$settings = $this->getFilterSetting($this->settings, 'settings', array());
$styles = $this->getFilterSetting($settings, 'styles', array());
$module = $this->getModule();
$fontsList = $module->getAllFontsList();
$defaultFont = $module->defaultFont;
$fontStyles = $module->getFontStyles();
$borderStyles = $module->getBorderStyles();

$useTitleStyles = $this->getFilterSetting($settings, 'use_title_styles', 0);
$hiddenStyle = $useTitleStyles ? '' : 'wpfHidden';
?>
<div class="row row-settings-block">
	<div class="settings-block-label col-xs-4 col-sm-3">
		<?php esc_html_e('Use Custom Styles', 'woo-product-filter'); ?>
	</div>
	<div class="col-xs-2 col-sm-1">
		<i class="fa fa-question woobewoo-tooltip" title="<?php echo esc_attr__('Choose your custom styles for filter titles. Any settings you leave blank will default.', 'woo-product-filter'); ?>"></i>
	</div>
	<div class="settings-block-values col-xs-6 col-sm-8">
		<div class="settings-value">
			<?php 
				HtmlWpf::checkboxToggle('settings[use_title_styles]', array(
					'checked' => $useTitleStyles
				));
				?>
		</div>
	</div>
</div>
<div class="row row-settings-block <?php echo esc_attr($hiddenStyle); ?>" data-parent="settings[use_title_styles]">
	<div class="settings-block-label col-xs-4 col-sm-3">
		<?php esc_html_e('Font', 'woo-product-filter'); ?>
	</div>
	<div class="col-xs-2 col-sm-1">
	</div>
	<div class="settings-block-values col-xs-6 col-sm-8">
		<div class="settings-value">
			<?php 
				HtmlWpf::selectbox('settings[styles][title_font_family]', array(
					'value' => $this->getFilterSetting($styles, 'title_font_family', $defaultFont),
					'options' => $fontsList,
					'attrs' => 'class="woobewoo-flat-input"'
				));
				?>
		</div>
		<div class="settings-value">
			<?php 
				HtmlWpf::text('settings[styles][title_font_size]', array(
					'value' => $this->getFilterSetting($styles, 'title_font_size', ''),
					'attrs' => 'class="woobewoo-flat-input woobewoo-number woobewoo-width60"'
				));
				?>
			<div class="settings-value-label">px</div>
		</div>
		<div class="settings-value">
			<?php 
				HtmlWpf::selectbox('settings[styles][title_font_style]', array(
					'value' => $this->getFilterSetting($styles, 'title_font_style', ''),
					'options' => $fontStyles,
					'attrs' => 'class="woobewoo-flat-input"'
				));
				?>
		</div>
		<div class="settings-value">
			<?php 
				HtmlWpf::colorpicker('settings[styles][title_font_color]', array(
					'value' => $this->getFilterSetting($styles, 'title_font_color', ''),
				));
				?>
		</div>
	</div>
</div>
<div class="row row-settings-block <?php echo esc_attr($hiddenStyle); ?>" data-parent="settings[use_title_styles]">
	<div class="settings-block-label col-xs-4 col-sm-3">
		<?php esc_html_e('Background', 'woo-product-filter'); ?>
	</div>
	<div class="col-xs-2 col-sm-1">
	</div>
	<div class="settings-block-values col-xs-6 col-sm-8">
		<div class="settings-value">
			<?php 
				HtmlWpf::colorpicker('settings[styles][title_bg_color]', array(
					'value' => $this->getFilterSetting($styles, 'title_bg_color', ''),
				));
				?>
		</div>
	</div>
</div>
<div class="row row-settings-block <?php echo esc_attr($hiddenStyle); ?>" data-parent="settings[use_title_styles]">
	<div class="settings-block-label col-xs-4 col-sm-3">
		<?php esc_html_e('Borders', 'woo-product-filter'); ?>
	</div>
	<div class="col-xs-2 col-sm-1">
	</div>
	<div class="settings-block-values col-xs-6 col-sm-8">
		<div class="settings-value">
			<?php 
				HtmlWpf::colorpicker('settings[styles][title_border_color]', array(
					'value' => $this->getFilterSetting($styles, 'title_border_color', ''),
				));
				?>
		</div>
		<div class="settings-value">
			<?php 
				HtmlWpf::selectbox('settings[styles][title_border_style]', array(
					'value' => $this->getFilterSetting($styles, 'title_border_style', ''),
					'options' => $borderStyles,
					'attrs' => 'class="woobewoo-flat-input"'
				));
				?>
		</div>
	</div>
</div>
<div class="row row-settings-block <?php echo esc_attr($hiddenStyle); ?>" data-parent="settings[use_title_styles]">
	<div class="settings-block-label col-xs-4 col-sm-3">
		<?php esc_html_e('Borders size', 'woo-product-filter'); ?>
	</div>
	<div class="col-xs-2 col-sm-1">
		<i class="fa fa-question woobewoo-tooltip" title="<?php echo esc_html(__('Set borders width in this order: top, right, bottom, left.', 'woo-product-filter')); ?>"></i>
	</div>
	<div class="settings-block-values col-xs-6 col-sm-8">
		<div class="settings-value">
			<?php 
				HtmlWpf::text('settings[styles][title_border_top]', array(
					'value' => $this->getFilterSetting($styles, 'title_border_top', '', true, false, true),
					'attrs' => 'class="wpfMiniInput"'
				));
				HtmlWpf::text('settings[styles][title_border_right]', array(
					'value' => $this->getFilterSetting($styles, 'title_border_right', '', true, false, true),
					'attrs' => 'class="wpfMiniInput"'
				));
				HtmlWpf::text('settings[styles][title_border_bottom]', array(
					'value' => $this->getFilterSetting($styles, 'title_border_bottom', '', true, false, true),
					'attrs' => 'class="wpfMiniInput"'
				));
				HtmlWpf::text('settings[styles][title_border_left]', array(
					'value' => $this->getFilterSetting($styles, 'title_border_left', '', true, false, true),
					'attrs' => 'class="wpfMiniInput"'
				));
				?>
			<div class="wpfRightLabel">px</div>
		</div>
	</div>
</div>
<div class="row row-settings-block <?php echo esc_attr($hiddenStyle); ?>" data-parent="settings[use_title_styles]">
	<div class="settings-block-label col-xs-4 col-sm-3">
		<?php esc_html_e('Padding', 'woo-product-filter'); ?>
	</div>
	<div class="col-xs-2 col-sm-1">
		<i class="fa fa-question woobewoo-tooltip" title="<?php echo esc_html(__('Set paddings in this order: top, right, bottom, left.', 'woo-product-filter')); ?>"></i>
	</div>
	<div class="settings-block-values col-xs-6 col-sm-8">
		<div class="settings-value">
			<?php 
				HtmlWpf::text('settings[styles][title_padding_top]', array(
					'value' => $this->getFilterSetting($styles, 'title_padding_top', '', true, false, true),
					'attrs' => 'class="wpfMiniInput"'
				));
				HtmlWpf::text('settings[styles][title_padding_right]', array(
					'value' => $this->getFilterSetting($styles, 'title_padding_right', '', true, false, true),
					'attrs' => 'class="wpfMiniInput"'
				));
				HtmlWpf::text('settings[styles][title_padding_bottom]', array(
					'value' => $this->getFilterSetting($styles, 'title_padding_bottom', '', true, false, true),
					'attrs' => 'class="wpfMiniInput"'
				));
				HtmlWpf::text('settings[styles][title_padding_left]', array(
					'value' => $this->getFilterSetting($styles, 'title_padding_left', '', true, false, true),
					'attrs' => 'class="wpfMiniInput"'
				));
				?>
			<div class="wpfRightLabel">px</div>
		</div>
	</div>
</div>
<div class="row row-settings-block <?php echo esc_attr($hiddenStyle); ?>" data-parent="settings[use_title_styles]">
	<div class="settings-block-label col-xs-4 col-sm-3">
		<?php esc_html_e('Margin', 'woo-product-filter'); ?>
	</div>
	<div class="col-xs-2 col-sm-1">
		<i class="fa fa-question woobewoo-tooltip" title="<?php echo esc_html(__('Set margins in this order: top, right, bottom, left.', 'woo-product-filter')); ?>"></i>
	</div>
	<div class="settings-block-values col-xs-6 col-sm-8">
		<div class="settings-value">
			<?php 
				HtmlWpf::text('settings[styles][title_margin_top]', array(
					'value' => $this->getFilterSetting($styles, 'title_margin_top', '', true, false, true),
					'attrs' => 'class="wpfMiniInput"'
				));
				HtmlWpf::text('settings[styles][title_margin_right]', array(
					'value' => $this->getFilterSetting($styles, 'title_margin_right', '', true, false, true),
					'attrs' => 'class="wpfMiniInput"'
				));
				HtmlWpf::text('settings[styles][title_margin_bottom]', array(
					'value' => $this->getFilterSetting($styles, 'title_margin_bottom', '', true, false, true),
					'attrs' => 'class="wpfMiniInput"'
				));
				HtmlWpf::text('settings[styles][title_margin_left]', array(
					'value' => $this->getFilterSetting($styles, 'title_margin_left', '', true, false, true),
					'attrs' => 'class="wpfMiniInput"'
				));
				?>
			<div class="wpfRightLabel">px</div>
		</div>
	</div>
</div>
