<?php
$settings = $this->getFilterSetting($this->settings, 'settings', array());
$styles = $this->getFilterSetting($settings, 'styles', array());
$module = $this->getModule();
$fontsList = $module->getAllFontsList();
$defaultFont = $module->defaultFont;
$fontStyles = $module->getFontStyles();
$borderStyles = $module->getBorderStyles();

$useBlockStyles = $this->getFilterSetting($settings, 'use_block_styles', 0);
$hiddenStyle = $useBlockStyles ? '' : 'wpfHidden';
?>
<div class="row row-settings-block">
	<div class="settings-block-label col-xs-4 col-sm-3">
		<?php esc_html_e('Use Custom Styles', 'woo-product-filter'); ?>
	</div>
	<div class="col-xs-2 col-sm-1">
		<i class="fa fa-question woobewoo-tooltip" title="<?php echo esc_attr__('Choose your custom styles for filter blocks. Any settings you leave blank will default.', 'woo-product-filter'); ?>"></i>
	</div>
	<div class="settings-block-values col-xs-6 col-sm-8">
		<div class="settings-value">
			<?php 
				HtmlWpf::checkboxToggle('settings[use_block_styles]', array(
					'checked' => $useBlockStyles
				));
				?>
		</div>
	</div>
</div>
<div class="row row-settings-block <?php echo esc_attr($hiddenStyle); ?>" data-parent="settings[use_block_styles]">
	<div class="settings-block-label col-xs-4 col-sm-3">
		<?php esc_html_e('Font', 'woo-product-filter'); ?>
	</div>
	<div class="col-xs-2 col-sm-1">
	</div>
	<div class="settings-block-values col-xs-6 col-sm-8">
		<div class="settings-value">
			<?php 
				HtmlWpf::selectbox('settings[styles][block_font_family]', array(
					'value' => $this->getFilterSetting($styles, 'block_font_family', $defaultFont),
					'options' => $fontsList,
					'attrs' => 'class="woobewoo-flat-input"'
				));
				?>
		</div>
		<div class="settings-value">
			<?php 
				HtmlWpf::text('settings[styles][block_font_size]', array(
					'value' => $this->getFilterSetting($styles, 'block_font_size', ''),
					'attrs' => 'class="woobewoo-flat-input woobewoo-number woobewoo-width60"'
				));
				?>
			<div class="settings-value-label">px</div>
		</div>
		<div class="settings-value">
			<?php 
				HtmlWpf::selectbox('settings[styles][block_font_style]', array(
					'value' => $this->getFilterSetting($styles, 'block_font_style', ''),
					'options' => $fontStyles,
					'attrs' => 'class="woobewoo-flat-input"'
				));
				?>
		</div>
		<div class="settings-value">
			<?php 
				HtmlWpf::colorpicker('settings[styles][block_font_color]', array(
					'value' => $this->getFilterSetting($styles, 'block_font_color', ''),
				));
				?>
		</div>
	</div>
</div>
<div class="row row-settings-block <?php echo esc_attr($hiddenStyle); ?>" data-parent="settings[use_block_styles]">
	<div class="settings-block-label col-xs-4 col-sm-3">
		<?php esc_html_e('Background', 'woo-product-filter'); ?>
	</div>
	<div class="col-xs-2 col-sm-1">
	</div>
	<div class="settings-block-values col-xs-6 col-sm-8">
		<div class="settings-value">
			<?php 
				HtmlWpf::colorpicker('settings[styles][block_bg_color]', array(
					'value' => $this->getFilterSetting($styles, 'block_bg_color', ''),
				));
				?>
		</div>
	</div>
</div>
<div class="row row-settings-block <?php echo esc_attr($hiddenStyle); ?>" data-parent="settings[use_block_styles]">
	<div class="settings-block-label col-xs-4 col-sm-3">
		<?php esc_html_e('Borders', 'woo-product-filter'); ?>
	</div>
	<div class="col-xs-2 col-sm-1">
	</div>
	<div class="settings-block-values col-xs-6 col-sm-8">
		<div class="settings-value">
			<?php 
				HtmlWpf::colorpicker('settings[styles][block_border_color]', array(
					'value' => $this->getFilterSetting($styles, 'block_border_color', ''),
				));
				?>
		</div>
		<div class="settings-value">
			<?php 
				HtmlWpf::selectbox('settings[styles][block_border_style]', array(
					'value' => $this->getFilterSetting($styles, 'block_border_style', ''),
					'options' => $borderStyles,
					'attrs' => 'class="woobewoo-flat-input"'
				));
				?>
		</div>
	</div>
</div>
<div class="row row-settings-block <?php echo esc_attr($hiddenStyle); ?>" data-parent="settings[use_block_styles]">
	<div class="settings-block-label col-xs-4 col-sm-3">
		<?php esc_html_e('Borders size', 'woo-product-filter'); ?>
	</div>
	<div class="col-xs-2 col-sm-1">
		<i class="fa fa-question woobewoo-tooltip" title="<?php echo esc_html(__('Set borders width in this order: top, right, bottom, left.', 'woo-product-filter')); ?>"></i>
	</div>
	<div class="settings-block-values col-xs-6 col-sm-8">
		<div class="settings-value">
			<?php 
				HtmlWpf::text('settings[styles][block_border_top]', array(
					'value' => $this->getFilterSetting($styles, 'block_border_top', '', true, false, true),
					'attrs' => 'class="wpfMiniInput"'
				));
				HtmlWpf::text('settings[styles][block_border_right]', array(
					'value' => $this->getFilterSetting($styles, 'block_border_right', '', true, false, true),
					'attrs' => 'class="wpfMiniInput"'
				));
				HtmlWpf::text('settings[styles][block_border_bottom]', array(
					'value' => $this->getFilterSetting($styles, 'block_border_bottom', '', true, false, true),
					'attrs' => 'class="wpfMiniInput"'
				));
				HtmlWpf::text('settings[styles][block_border_left]', array(
					'value' => $this->getFilterSetting($styles, 'block_border_left', '', true, false, true),
					'attrs' => 'class="wpfMiniInput"'
				));
				?>
			<div class="wpfRightLabel">px</div>
		</div>
	</div>
</div>
<div class="row row-settings-block <?php echo esc_attr($hiddenStyle); ?>" data-parent="settings[use_block_styles]">
	<div class="settings-block-label col-xs-4 col-sm-3">
		<?php esc_html_e('Padding', 'woo-product-filter'); ?>
	</div>
	<div class="col-xs-2 col-sm-1">
		<i class="fa fa-question woobewoo-tooltip" title="<?php echo esc_html(__('Set paddings in this order: top, right, bottom, left.', 'woo-product-filter')); ?>"></i>
	</div>
	<div class="settings-block-values col-xs-6 col-sm-8">
		<div class="settings-value">
			<?php 
				HtmlWpf::text('settings[styles][block_padding_top]', array(
					'value' => $this->getFilterSetting($styles, 'block_padding_top', '', true, false, true),
					'attrs' => 'class="wpfMiniInput"'
				));
				HtmlWpf::text('settings[styles][block_padding_right]', array(
					'value' => $this->getFilterSetting($styles, 'block_padding_right', '', true, false, true),
					'attrs' => 'class="wpfMiniInput"'
				));
				HtmlWpf::text('settings[styles][block_padding_bottom]', array(
					'value' => $this->getFilterSetting($styles, 'block_padding_bottom', '', true, false, true),
					'attrs' => 'class="wpfMiniInput"'
				));
				HtmlWpf::text('settings[styles][block_padding_left]', array(
					'value' => $this->getFilterSetting($styles, 'block_padding_left', '', true, false, true),
					'attrs' => 'class="wpfMiniInput"'
				));
				?>
			<div class="wpfRightLabel">px</div>
		</div>
	</div>
</div>
<div class="row row-settings-block <?php echo esc_attr($hiddenStyle); ?>" data-parent="settings[use_block_styles]">
	<div class="settings-block-label col-xs-4 col-sm-3">
		<?php esc_html_e('Margin', 'woo-product-filter'); ?>
	</div>
	<div class="col-xs-2 col-sm-1">
		<i class="fa fa-question woobewoo-tooltip" title="<?php echo esc_html(__('Set margins in this order: top, right, bottom, left.', 'woo-product-filter')); ?>"></i>
	</div>
	<div class="settings-block-values col-xs-6 col-sm-8">
		<div class="settings-value">
			<?php 
				HtmlWpf::text('settings[styles][block_margin_top]', array(
					'value' => $this->getFilterSetting($styles, 'block_margin_top', '', true, false, true),
					'attrs' => 'class="wpfMiniInput"'
				));
				HtmlWpf::text('settings[styles][block_margin_right]', array(
					'value' => $this->getFilterSetting($styles, 'block_margin_right', '', true, false, true),
					'attrs' => 'class="wpfMiniInput"'
				));
				HtmlWpf::text('settings[styles][block_margin_bottom]', array(
					'value' => $this->getFilterSetting($styles, 'block_margin_bottom', '', true, false, true),
					'attrs' => 'class="wpfMiniInput"'
				));
				HtmlWpf::text('settings[styles][block_margin_left]', array(
					'value' => $this->getFilterSetting($styles, 'block_margin_left', '', true, false, true),
					'attrs' => 'class="wpfMiniInput"'
				));
				?>
			<div class="wpfRightLabel">px</div>
		</div>
	</div>
</div>
<div class="row row-settings-block <?php echo esc_attr($hiddenStyle); ?>" data-parent="settings[use_block_styles]">
	<div class="settings-block-label col-xs-4 col-sm-3">
		<?php esc_html_e('Checkboxes', 'woo-product-filter'); ?>
	</div>
	<div class="col-xs-2 col-sm-1">
		<i class="fa fa-question woobewoo-tooltip" title="<?php echo esc_html(__('Set styles for checkboxes.', 'woo-product-filter')); ?>"></i>
	</div>
	<div class="settings-block-values col-xs-6 col-sm-8">
		<div class="settings-value">
			<?php 
				HtmlWpf::selectbox('settings[styles][block_checkbox_type]', array(
					'value' => $this->getFilterSetting($styles, 'block_checkbox_type', ''),
					'options' => array(
						'' => esc_attr__('Default', 'woo-product-filter'),
						'circle' => esc_attr__('Circle', 'woo-product-filter'),
						'square' => esc_attr__('Square', 'woo-product-filter'),
						'round' => esc_attr__('Square rounded corners', 'woo-product-filter')),
					'attrs' => 'class="woobewoo-flat-input"'
				));
				?>
			</div>
		<div class="settings-value" data-select="settings[styles][block_checkbox_type]" data-select-value="circle|square|round">
			<?php
				HtmlWpf::text('settings[styles][block_checkbox_size]', array(
					'value' => $this->getFilterSetting($styles, 'block_checkbox_size', '', true),
					'attrs' => 'class="woobewoo-flat-input woobewoo-number woobewoo-width60"'
				));
				?>
			<div class="settings-value-label">px</div>
		</div>
		<div class="settings-value" data-select="settings[styles][block_checkbox_type]" data-select-value="circle|square|round">
			<div class="settings-value-label">
				<?php esc_html_e('border', 'woo-product-filter'); ?>
			</div>
			<?php 
				HtmlWpf::colorpicker('settings[styles][block_checkbox_border]', array(
					'value' => $this->getFilterSetting($styles, 'block_checkbox_border', ''),
				));
				?>
		</div>
		<div class="clear"></div>
		<div class="settings-value" data-select="settings[styles][block_checkbox_type]" data-select-value="circle|square|round">
			<div class="settings-value-label woobewoo-width80">
				<?php esc_html_e('unchecked', 'woo-product-filter'); ?>
			</div>
			<?php 
				HtmlWpf::colorpicker('settings[styles][block_checkbox_color]', array(
					'value' => $this->getFilterSetting($styles, 'block_checkbox_color', ''),
				));
				?>
		</div>
		<div class="clear"></div>
		<div class="settings-value" data-select="settings[styles][block_checkbox_type]" data-select-value="circle|square|round">
			<div class="settings-value-label woobewoo-width80">
				<?php esc_html_e('checked', 'woo-product-filter'); ?>
			</div>
			<?php 
				HtmlWpf::colorpicker('settings[styles][block_checkbox_checked_color]', array(
					'value' => $this->getFilterSetting($styles, 'block_checkbox_checked_color', ''),
				));
				?>
		</div>
		<div class="settings-value" data-select="settings[styles][block_checkbox_type]" data-select-value="circle|square|round">
			<div class="settings-value-label">
				<?php esc_html_e('checkmark', 'woo-product-filter'); ?>
			</div>
			<?php 
				HtmlWpf::colorpicker('settings[styles][block_checkbox_mark_color]', array(
					'value' => $this->getFilterSetting($styles, 'block_checkbox_mark_color', ''),
				));
				?>
		</div>
	</div>
</div>
