<?php
class WoofilterProWpf extends ModuleWpf {
	public $defaultFont = 'Default';
	public $acf_prefix = 'acf-';
	public $ctax_prefix = 'ctax-';
	public $acfFields = array();

	public function init() {
		parent::init();
		DispatcherWpf::addAction('addScriptsContent', array($this, 'addScriptsContent'), 10, 2);
		DispatcherWpf::addAction('addEditTabFilters', array($this, 'addEditTabFilters'), 10, 2);
		DispatcherWpf::addAction('addEditTabDesign', array($this, 'addEditTabDesign'), 10, 2);
		DispatcherWpf::addAction('addArgsForFilteringBySettings', array($this, 'addArgsForFilteringBySettings'), 10, 2);

		DispatcherWpf::addFilter('addFilterTypes', array($this, 'addFilterTypes'));
		DispatcherWpf::addFilter('getSettingOverlayWord', array($this, 'getSettingOverlayWord'));
		DispatcherWpf::addFilter('getFrontendFilterTypes', array($this, 'getFrontendFilterTypes'), 10, 2);
		DispatcherWpf::addFilter('optionsDefine', array($this, 'addOptions'));
		DispatcherWpf::addFilter('addHtmlBeforeFilter', array($this, 'addHtmlBeforeFilter'), 10, 2);
		DispatcherWpf::addFilter('getTaxonomyOptionsHtml', array($this, 'getTaxonomyOptionsHtml'), 10, 2);
		DispatcherWpf::addFilter('getOneTaxonomyOptionHtml', array($this, 'getOneTaxonomyOptionHtml'), 10, 2);
		DispatcherWpf::addFilter('controlFilterSettings', array($this, 'controlFilterSettings'), 10, 2);
		DispatcherWpf::addFilter('addCustomCss', array($this, 'addCustomCss'), 10, 3);
		DispatcherWpf::addFilter('getCustomAttributeName', array($this, 'getCustomAttributeName'), 10, 2);
		DispatcherWpf::addFilter('addCustomAttributes', array($this, 'addCustomAttributes'), 10, 2);
		DispatcherWpf::addFilter('getCustomTerms', array($this, 'getCustomTerms'), 10, 4);
		DispatcherWpf::addFilter('addCustomAttributesSql', array($this, 'addCustomAttributesSql'), 10, 2);
		DispatcherWpf::addFilter('getFilterArgsPro', array($this, 'getFilterArgsPro'), 10, 2);
		DispatcherWpf::addFilter('loadProductsFilterPro', array($this, 'loadProductsFilterPro'), 10, 2);
		DispatcherWpf::addFilter('getAttrFilterLogic', array($this, 'getAttrFilterLogicPro'), 10, 1);

		add_filter('posts_clauses', array($this, 'addSearchTextClauses'), 10, 2);
	}


	public function addScriptsContent( $adminArea, $settings ) {
		$modPath = $this->getModPath();
		if ($adminArea) {
			FrameWpf::_()->addScript('admin.filters.pro', $modPath . 'js/admin.woofilters.pro.js', array('jquery'));
			FrameWpf::_()->addStyle('admin.filters.pro', $modPath . 'css/admin.woofilters.pro.css');
			$jsData = file_exists($this->getModDir() . 'files/fontAwesomeList.txt') ? file($this->getModDir() . 'files/fontAwesomeList.txt') : array();
			if (!empty($jsData)) {
				$jsData = array_map(function( $item ) {
					return 'fa-' . trim($item); 
				}, $jsData);
			}
			FrameWpf::_()->addJSVar('admin.filters.pro', 'FONT_AWESOME_DATA', $jsData);
		}

		FrameWpf::_()->addScript('frontend.filters.pro', $modPath . 'js/frontend.woofilters.pro.js', array('jquery'));
		FrameWpf::_()->addStyle('frontend.filters.pro', $modPath . 'css/frontend.woofilters.pro.css');

		if ($adminArea || empty($settings['settings']['disable_plugin_styles'])) {
			FrameWpf::_()->addStyle('custom.filters.pro', $modPath . 'css/custom.woofilters.pro.css');
		}

		FrameWpf::_()->addScript('jquery-ui-autocomplete', '', array('jquery'), false, true);
		FrameWpf::_()->addStyle('jquery-ui-autocomplete', $modPath . 'css/jquery-ui-autocomplete.css');

		FrameWpf::_()->addScript('ion.slider', $modPath . 'js/ion.rangeSlider.min.js', array('jquery'));
		FrameWpf::_()->addStyle('ion.slider', $modPath . 'css/ion.rangeSlider.css');
	}

	public function addFilterTypes( $filters ) {
		if (taxonomy_exists('product_brand')) {
			$filters['wpfBrand'] = array('name' => esc_html__('Product brands', 'woo-product-filter'), 'enabled' => true, 'unique' => true);
		}
		$filters['wpfSearchText']['enabled'] = true;
		return $filters;
	}

	public function addEditTabFilters( $part ) {
		$this->getView()->addEditTabFilters($part);
	}

	public function addEditTabDesign( $part, $settings ) {
		$this->getView()->addEditTabDesign($part, $settings);
	}

	public function getFrontendFilterTypes( $types, $filter ) {
		switch ($filter) {
			case 'wpfCategory':
			case 'wpfPerfectBrand':
				$types = array_merge($types, array('multi', 'buttons', 'text'));
				break;
			case 'wpfTags':
				$types = array_merge($types, array('buttons', 'text'));
				break;
			case 'wpfAttribute':
				$types = array_merge($types, array('buttons', 'text', 'switch'));
				break;
			case 'wpfFeatured':
			case 'wpfOnSale':
			case 'wpfInStock':
				$types = array_merge($types, array('switch'));
				break;
			default:
				break;
		}
		return $types;
	}

	public function addHtmlBeforeFilter( $html, $settings ) {
		return $html . $this->getView()->addHideFiltersButton($settings);
	}
	public function addCustomCss( $css, $settings, $filterId ) {
		return $this->getView()->addCustomCss($settings, $filterId) . $css;
	}

	public function getTaxonomyOptionsHtml( $html, $options ) {
		if (!isset($options['type'])) {
			return $html;
		}

		$type = $options['type'];
		$view = $this->getView();
		switch ($type) {
			case 'buttons':
				$html = $view->getButtonsTypeHtml($options);
				break;
			case 'text':
				$html = $view->getTextTypeHtml($options);
				break;
			case 'switch':
				$html = $view->getSwitchTypeHtml($options);
				break;
			default:
				break;
		}
		return $html;
	}
	public function getOneTaxonomyOptionHtml( $html, $options ) {
		if (!isset($options['type'])) {
			return $html;
		}

		$type = $options['type'];
		$view = $this->getView();
		switch ($type) {
			case 'switch':
				$html = $view->generateToggleSwitchHtml($options['id'], $options['checked']);
				break;
			default:
				break;
		}
		return $html;
	}

	public function controlFilterSettings( $filter ) {
		return $this->getView()->controlFilterSettings($filter);
	}

	public function getSearchTextSQL( $attribute, $value, $clauses ) {
		global $wpdb;
		if (empty($value)) {
			return $clauses;
		}
		//tcea: t - title, c - content, e - excerpt, a - attributes
		//o/i - or/and
		//w/l - word/like
		$attrs = str_replace('pr_search_', '', $attribute);
		$word = strpos($attrs, 'w') !== false;
		$like = $word ? 'REGEXP' : 'LIKE';
		$value = $wpdb->esc_like($value);
		$term = $word ? '[[:<:]]' . $value . '[[:>:]]' : '%' . $value . '%';
		$orAnd = strpos($attrs, 'o') === false ? ' AND ' : ' OR ';

		$where = '';
		if (strpos($attrs, 't') !== false) {
			$where = $word ? $wpdb->prepare("($wpdb->posts.post_title REGEXP %s)", $term) : $wpdb->prepare("($wpdb->posts.post_title LIKE %s)", $term);
		}
		if (strpos($attrs, 'c') !== false) {
			$where .= ( empty($where) ? '' : $orAnd ) .
				( $word ? $wpdb->prepare("($wpdb->posts.post_content REGEXP %s)", $term) : $wpdb->prepare("($wpdb->posts.post_content LIKE %s)", $term) );
		}
		if (strpos($attrs, 'e') !== false) {
			$where .= ( empty($where) ? '' : $orAnd ) . 
				( $word ? $wpdb->prepare("($wpdb->posts.post_excerpt REGEXP %s)", $term) : $wpdb->prepare("($wpdb->posts.post_excerpt LIKE %s)", $term) );
		}
		if (strpos($attrs, 'a') !== false) {
			$clauses['join'] .= " LEFT OUTER JOIN {$wpdb->term_relationships} AS wtbp_rel ON (wtbp_rel.object_id={$wpdb->posts}.ID)";
			$clauses['join'] .= " LEFT OUTER JOIN {$wpdb->term_taxonomy} AS wtbp_tax ON (wtbp_tax.term_taxonomy_id=wtbp_rel.term_taxonomy_id and wtbp_tax.taxonomy LIKE 'pa_%')";
			if ($word) {
				$clauses['join'] .= $wpdb->prepare(" LEFT OUTER JOIN {$wpdb->terms} AS wtbp_terms ON (wtbp_terms.term_id=wtbp_tax.term_id AND wtbp_terms.name REGEXP %s)", $term);
				$clauses['join'] .= $wpdb->prepare(" LEFT OUTER JOIN {$wpdb->postmeta} AS wtbp_meta ON ({$wpdb->posts}.ID = wtbp_meta.post_id AND wtbp_meta.meta_key LIKE %s AND wtbp_meta.meta_value REGEXP %s)", array('attribute_%', $term));
			} else {
				$clauses['join'] .= $wpdb->prepare(" LEFT OUTER JOIN {$wpdb->terms} AS wtbp_terms ON (wtbp_terms.term_id=wtbp_tax.term_id AND wtbp_terms.name LIKE %s)", $term);
				$clauses['join'] .= $wpdb->prepare(" LEFT OUTER JOIN {$wpdb->postmeta} AS wtbp_meta ON ({$wpdb->posts}.ID = wtbp_meta.post_id AND wtbp_meta.meta_key LIKE %s AND wtbp_meta.meta_value LIKE %s)", array('attribute_%', $term));
			}
			$where .= ( empty($where) ? '' : $orAnd ) . '(wtbp_terms.term_id is not NULL OR wtbp_meta.post_id is not NULL)';
			$clauses['groupby'] = "{$wpdb->posts}.ID";
		}
		if (!empty($where)) {
			$clauses['where'] .= ' AND (' . $where . ')';
		}
		return $clauses;
	}
	public function getSearchTextExcludedSQL( $excluded ) {
		global $wpdb;
		$sql = '';
		foreach ($excluded as $exclude) {
			$parts = explode('__', $exclude);
			$attr = $parts[0];
			switch ($attr) {
				case 'products':
					$sql .= $wpdb->prepare("AND ($wpdb->posts.ID != %d)", $parts[1]);
					break;
				case 'product_cat':
				case 'product_tag':
				default:
					$sql .= $wpdb->prepare("AND ($wpdb->posts.ID NOT IN (SELECT object_id FROM $wpdb->term_relationships AS wtr WHERE wtr.term_taxonomy_id = %d))", $parts[1]);
					break;
			}
		}
		return $sql;
	}
	public function addSearchTextClauses( $clauses, $wp_query ) {
		if ( $wp_query->is_main_query() && isset($wp_query->query['post_type']) && 'product' == $wp_query->query['post_type'] ) {
			$vars = ReqWpf::get('get');
			foreach ($vars as $key => $value) {
				if ( strpos($key, 'pr_search_') === 0 && !is_null($value) && strlen($value) > 0 ) {
					return $this->getSearchTextSQL($key, $value, $clauses);
					break;
				}
			}
		}
		return $clauses;
	}

	public function addArgsForFilteringBySettings( $settings ) {
		foreach ($settings as $setting) {
			if ('wpfSearchText' == $setting['id']) {
				$text = $setting['settings']['value'];
				$attr = $setting['settings']['attribute'];
				$excluded = $setting['settings']['excluded'];

				add_filter('posts_clauses', function( $clauses, $wp_query ) use ( $attr, $text ) {
					return $this->getSearchTextSQL($attr, $text, $clauses);
				}, 10, 2);
				if ($excluded) {
					add_filter('posts_where', function( $where ) use ( $excluded ) {
						$where .= $this->getSearchTextExcludedSQL($excluded);
						return $where;
					});
				}
			}
		}
	}

	public function addOptions( $options ) {
		$opts = array_merge($options['general']['opts'], array(
			'loader_enable' => array('label' => esc_html__('Enable filter icon on load', 'woo-product-filter'), 'desc' => esc_html__('Show filter icon while page is loading.', 'woo-product-filter'), 'def' => '1', 'html' => 'checkboxHiddenVal'),
			'loader_icon_color' => array('label' => esc_html__('Filter Loader Color', 'woo-product-filter'), 'desc' => esc_html__('Here you may select the color of filter loader animation.', 'woo-product-filter'), 'def' => '#000000', 'html' => 'colorpicker'),
			'loader_icon' => array('label' => esc_html__('Filter Loader Icon', 'woo-product-filter'), 'desc' => esc_html__('Here you may select the animated loader, which appears when filter is loading.', 'woo-product-filter'),
			'html' => ( method_exists('HtmlWpf', 'selectIcon') ? 'selectIcon' : 'hidden' ), 'def' => 'default|0', 'add_sub_opts' => array($this, 'getSettingsLoaderHtml')),
		));

		$options['general']['opts'] = $opts;
		return $options;
	}
	public function getSettingsLoaderHtml( $options ) {
		$opts = $options['general']['opts'];
		$icon = !empty($opts['loader_icon']['value']) ? $opts['loader_icon']['value'] : 'default|0';
		$parts = explode('|', $icon);
		if (count($parts) == 2) {
			$iconName =	$parts[0];
			$iconNumber =	$parts[1];
		} else {
			$iconName =	'default';
			$iconNumber = '0';
		}

		if ('default' === $iconName) {
			$htmlPreview = '<div class="woobewoo-filter-loader"><i class="fa fa-spinner fa-pulse fa-3x fa-fw"></i></div>';
		} else {
			$htmlPreview = '<div class="woobewoo-filter-loader la-' . $iconName . ' la-2x">';
			for ($i = 1; $i <= $iconNumber; $i++) {
				$htmlPreview .= '<div></div>';
			}
			$htmlPreview .= '</div>';
		}
		$loaderSkins = array(
					'timer' => 1,
					'ball-beat'=> 3,
					'ball-circus'=> 5,
					'ball-atom'=> 4,
					'ball-spin-clockwise-fade-rotating'=> 8,
					'line-scale'=> 5,
					'ball-climbing-dot'=> 4,
					'square-jelly-box'=> 2,
					'ball-rotate'=> 1,
					'ball-clip-rotate-multiple'=> 2,
					'cube-transition'=> 2,
					'square-loader'=> 1,
					'ball-8bits'=> 16,
					'ball-newton-cradle'=> 4,
					'ball-pulse-rise'=> 5,
					'triangle-skew-spin'=> 1,
					'fire'=> 3,
					'ball-zig-zag-deflect'=> 2
				);

		$html = HtmlWpf::hidden('opt_values[loader_icon]', array('value' => $iconName . '|' . $iconNumber)) .
			'<div class="wpfIconPreview">' . $htmlPreview . '</div>
			<div class="wpfLoaderIconTemplate wpfHidden">
				<div class="items items-list">
					<div class="item">
						<div class="item-inner">
							<div class="item-loader-container">
								<div class="preicon_img" data-name="default" data-items="0">
									<div class="woobewoo-filter-loader"><i class="fa fa-spinner fa-pulse fa-3x fa-fw"></i></div>
								</div>
							</div>
						</div>
						<div class="item-title">default</div>
					</div>';
		foreach ($loaderSkins as $name => $number) {
			$html .= '<div class="item">
				<div class="item-inner">
					<div class="item-loader-container">
						<div class="woobewoo-filter-loader la-' . $name . ' la-2x preicon_img" data-name="' . $name . '" data-items="' . $number . '">';
			for ($i = 0; $i < $number; $i++) {
				$html .= '<div></div>';
			}
			$html .= '</div>
					</div>
				</div>
				<div class="item-title">' . $name . '</div>
				</div>';
		}
		$html .= '</div></div>';
		return $html;
	}

	public function addCustomAttributes( $attributes ) {
		$exclude = array('product_type', 'product_visibility', 'product_cat', 'product_tag', 'product_shipping_class');
		foreach ($attributes as $attr) {
			$exclude[] = 'pa_' . $attr->attribute_name;
		}
		foreach (get_object_taxonomies('product', 'objects') as $slug => $tax) {
			if (!in_array($slug, $exclude)) {
				$attr = new stdClass();
				$attr->attribute_id = 0;
				$attr->attribute_name = $slug;
				$attr->attribute_slug = $this->ctax_prefix . $slug;
				$attr->attribute_label = $tax->label;
				$attr->filter_name = 'filter_' . $slug;
				$attr->custom_type = 'text';
				$attributes[] = $attr;
			}
		}
		if ($this->isACFPluginActivated()) {
			$enabledTypes = array('text', 'number', 'radio', 'select', 'button_group', 'checkbox', 'true_false', 'date_picker', 'date_time_picker', 'time_picker', 'color_picker');

			$groups = acf_get_field_groups();
			if (is_array($groups)) {
				foreach ($groups as $group) {
					$forProduct = false;
					if (!is_array($group['location'])) {
						continue;
					}
					foreach ($group['location'] as $location) {
						if (!is_array($location)) {
							continue;
						}
						foreach ($location as $obj) {
							if ('post_type' == $obj['param'] && '==' == $obj['operator'] && 'product' == $obj['value']) {
								$forProduct = true;
								break;
							}
						}
					}
					if (!$forProduct) {
						continue;
					}
					$fields = acf_get_fields($group['ID']);
					foreach ($fields as $field) {
						if (empty($field['name']) || empty($field['label'])) {
							continue;
						}
						$type = $field['type'];
						if (!in_array($type, $enabledTypes)) {
							continue;
						}
						$slug = $this->acf_prefix . $field['name'];
						
						$attr = new stdClass();
						$attr->attribute_id = 0;
						$attr->attribute_name = $field['name'];
						$attr->attribute_slug = $slug;
						$attr->attribute_label = $field['label'];
						$attr->filter_name = $slug;

						$attr->custom_type = $type;
						$attributes[] = $attr;
					}
				}
			}
		}
		return $attributes;
		
	}
	public function getCustomAttributeName( $slug ) {
		if (strpos($slug, $this->ctax_prefix) === 0) {
			$slug = str_replace($this->ctax_prefix, '', $slug);
		}
		return $slug;
	}
	public function getCustomTerms( $terms, $slug, $args ) {
		if (strpos($slug, $this->ctax_prefix) === 0) {
			return get_terms(str_replace($this->ctax_prefix, '', $slug), $args);

		} else if (strpos($slug, $this->acf_prefix) === 0) {
			$key = str_replace($this->acf_prefix, '', $slug);

			if (!isset($this->acfFields[$key])) {
				$this->acfFields[$key] = acf_get_field($key);
			}
			if (empty($this->acfFields[$key])) {
				return $terms;
			}

			$acfSetting = $this->acfFields[$key];
			$acfType = $acfSetting['type'];
			$includeValues = isset($args['include']) ? $args['include'] : false;

			if ( isset($acfSetting['choices']) && is_array($acfSetting['choices']) ) {
				foreach ($acfSetting['choices'] as $value => $name) {
					if ( !$includeValues || in_array($value, $includeValues) ) {
						$term = new stdClass();
						$term->term_id = $this->clearIdString($value);
						$term->name = $name;
						$term->slug = $name;
						$term->count = 0;
						$terms[] = $term;
					}
				}
				if ( $includeValues && isset($args['orderby']) && 'include' == $args['orderby'] ) {
					$order = array();
					foreach ($includeValues as $value) {
						foreach ($terms as $term) {
							if ($term->term_id == $value) {
								$order[] = $term;
							}
						}
					}
					$terms = $order;
				}

			} else if ('true_false' == $acfType) {
				$term = new stdClass();
				$term->term_id = 1;
				$term->name = $acfSetting['label'];
				$term->slug = 1;
				$term->count = 0;
				$terms[] = $term;
			} else {
				$args = array (
					'post_type' => 'product',
					'posts_per_page' => -1,
					'fields' => 'ids',
					'ignore_sticky_posts' => true,
					'meta_query' => array(
						'relation' => 'AND',
						array(
							'key' => $key, 
							'compare' => 'EXISTS'
						),
						array(
							'key' => $key, 
							'value' => '',
							'compare' => '!='
						)
					)
				);
				
				$terms = array();
				$products = new WP_Query($args);
				$uniq = array();
				if ($products->found_posts) {			
					foreach ($products->posts as $id) {
						$ident = $this->clearIdString(get_field($key, $id, false));
						if ( '' != $ident && '0' != $ident && !in_array($ident, $uniq) ) {
							$term = new stdClass();
							$term->term_id = $ident;
							$term->name = get_field($key, $id, true);
							$term->slug = $term->term_id;
							$term->count = 0;
							$terms[] = $term;
							$uniq[] = $ident;
						}
					}
				}
				wp_reset_query();
			}
		}
		return $terms;
	}

	public function addCustomAttributesSql( $sql, $agrs ) {
		global $wpdb;
		$productList = $agrs['productList'];
		$withCount = $agrs['withCount'];
		foreach ($agrs['taxonomies'] as $slug) {
			if (strpos($slug, $this->acf_prefix) === 0) {
				$key = str_replace($this->acf_prefix, '', $slug);
				$acfSetting = acf_get_field($key);
				$metaValue = 'meta_value';
				if ( isset($acfSetting['choices']) && is_array($acfSetting['choices']) && is_array($acfSetting['default_value']) ) {
					foreach ($acfSetting['choices'] as $value => $name) {
						$value = $this->clearIdString($value);
						$sql .= ' UNION ALL SELECT ' . ( $withCount ? '' : 'DISTINCT ' ) . " 0 as term_taxonomy_id, '$value' as term_id, meta_key as taxonomy, 0 as parent" . ( $withCount ? ', COUNT(*) as cnt' : '' ) .
							" FROM $wpdb->postmeta pm
							WHERE pm.post_id IN (" . $productList . ")
							AND pm.meta_key='$key' AND meta_value LIKE '%:\"" . $value . "\";%'";
						if ($withCount) {
							$sql .= " GROUP BY '$value'";
						}
					}
				} else {
					$sql .= ' UNION ALL SELECT ' . ( $withCount ? '' : 'DISTINCT ' ) . ' 0 as term_taxonomy_id, meta_value as term_id, meta_key as taxonomy, 0 as parent' . ( $withCount ? ', COUNT(*) as cnt' : '' ) .
						" FROM $wpdb->postmeta pm
						WHERE pm.post_id IN (" . $productList . ")
						AND pm.meta_key='" . $key . "' AND pm.meta_value != ''";
					if ($withCount) {
						$sql .= ' GROUP BY meta_value';
					}
				}
			}
		}
		return $sql;

	}
	public function clearIdString( $id ) {
		return str_replace("'", '', str_replace('"', '', $id));
	}
	
	public function loadProductsFilterPro( $q ) {
		$module = FrameWpf::_()->getModule('woofilters');
		$getGet = array_merge($module->getPreselectedValue(), ReqWpf::get('get'));

		foreach ($getGet as $key => $value) {
			if (strpos($key, $this->acf_prefix) === 0) {
				$param = ReqWpf::getVar($key, 'all', $module->getPreselectedValue($key));
				if (is_null($param)) {
					continue;
				}

				$idsAnd = explode(', ', $param);
				$idsOr = explode('|', $param);
				$isAnd = count($idsAnd) > count($idsOr);
				$terms = $isAnd ? $idsAnd : $idsOr;
				
				$key = str_replace($this->acf_prefix, '', $key);
				$acfSetting = acf_get_field($key);
				$multi = isset($acfSetting['default_value']) && is_array($acfSetting['default_value']);
				$metaQuery = array();
				if ($multi) {
					$metaQuery['relation'] = $isAnd ? 'AND' : 'OR';
					foreach ($terms as $term) {
						$metaQuery[] = array('key' => $key, 'value' => ':"' . $term . '";', 'compare' => 'LIKE');
					}
				} else {
					if ($isAnd) {
						$metaQuery['relation'] = 'AND';
						foreach ($terms as $term) {
							$metaQuery[] = array('key' => $key, 'value' => $term, 'compare' => '=');
						}
					} else {
						$metaQuery[] = array('key' => $key, 'value' => $terms, 'compare' => 'IN');
					}
				}  
				if (count($metaQuery) > 0) {
					$q->set('meta_query', array_merge($q->get('meta_query'), $metaQuery));
				}         
			}
		}
		return $q;
	}

	public function getFilterArgsPro( $args, $setting ) {
		if ( 'wpfAttribute' == $setting['id'] && strpos($setting['name'], $this->acf_prefix) === 0 ) {
			$terms = $setting['settings'];
			if ($terms) {
				$key = str_replace($this->acf_prefix, '', $setting['name']);
				$acfSetting = acf_get_field($key);
				$multi = isset($acfSetting['default_value']) && is_array($acfSetting['default_value']);
				$isOr = isset($setting['logic']) && ( 'or' == $setting['logic'] );
				$metaQuery = array();
				if ($multi) {
					$metaQuery['relation'] = $isOr ? 'OR' : 'AND';
					foreach ($terms as $term) {
						$metaQuery[] = array('key' => $key, 'value' => ':"' . $term . '";', 'compare' => 'LIKE');
					}
				} else {
					if ($isOr) {
						$metaQuery[] = array('key' => $key, 'value' => $terms, 'compare' => 'IN');
					} else {
						$metaQuery['relation'] = 'AND';
						foreach ($terms as $term) {
							$metaQuery[] = array('key' => $key, 'value' => $term, 'compare' => '=');
						}
					}
				}
				$args = array('meta_query' => $metaQuery);
			}
		}
		return $args;
	}

	public function isACFPluginActivated() {
		return class_exists('acf');
	}
	public function getFontsList() {
		return array('ABeeZee', 'Abel', 'Abril Fatface', 'Aclonica', 'Acme', 'Actor', 'Adamina', 'Advent Pro', 'Aguafina Script', 'Akronim', 'Aladin', 'Aldrich', 'Alef', 'Alegreya', 'Alegreya SC', 'Alegreya Sans', 'Alegreya Sans SC', 'Alex Brush', 'Alfa Slab One', 'Alice', 'Alike', 'Alike Angular', 'Allan', 'Allerta', 'Allerta Stencil', 'Allura', 'Almendra', 'Almendra Display', 'Almendra SC', 'Amarante', 'Amaranth', 'Amatic SC', 'Amethysta', 'Amiri', 'Anaheim', 'Andada', 'Andika', 'Angkor', 'Annie Use Your Telescope', 'Anonymous Pro', 'Antic', 'Antic Didone', 'Antic Slab', 'Anton', 'Arapey', 'Arbutus', 'Arbutus Slab', 'Architects Daughter', 'Archivo Black', 'Archivo Narrow', 'Arimo', 'Arizonia', 'Armata', 'Artifika', 'Arvo', 'Asap', 'Asset', 'Astloch', 'Asul', 'Atomic Age', 'Aubrey', 'Audiowide', 'Autour One', 'Average', 'Average Sans', 'Averia Gruesa Libre', 'Averia Libre', 'Averia Sans Libre', 'Averia Serif Libre', 'Bad Script', 'Balthazar', 'Bangers', 'Basic', 'Battambang', 'Baumans', 'Bayon', 'Belgrano', 'Belleza', 'BenchNine', 'Bentham', 'Berkshire Swash', 'Bevan', 'Bigelow Rules', 'Bigshot One', 'Bilbo', 'Bilbo Swash Caps', 'Biryani', 'Bitter', 'Black Ops One', 'Bokor', 'Bonbon', 'Boogaloo', 'Bowlby One', 'Bowlby One SC', 'Brawler', 'Bree Serif', 'Bubblegum Sans', 'Bubbler One', 'Buenard', 'Butcherman', 'Butterfly Kids', 'Cabin', 'Cabin Condensed', 'Cabin Sketch', 'Caesar Dressing', 'Cagliostro', 'Calligraffitti', 'Cambay', 'Cambo', 'Candal', 'Cantarell', 'Cantata One', 'Cantora One', 'Capriola', 'Cardo', 'Carme', 'Carrois Gothic', 'Carrois Gothic SC', 'Carter One', 'Caudex', 'Cedarville Cursive', 'Ceviche One', 'Changa One', 'Chango', 'Chau Philomene One', 'Chela One', 'Chelsea Market', 'Chenla', 'Cherry Cream Soda', 'Cherry Swash', 'Chewy', 'Chicle', 'Chivo', 'Cinzel', 'Cinzel Decorative', 'Clicker Script', 'Coda', 'Codystar', 'Combo', 'Comfortaa', 'Coming Soon', 'Concert One', 'Condiment', 'Content', 'Contrail One', 'Convergence', 'Cookie', 'Copse', 'Corben', 'Courgette', 'Cousine', 'Coustard', 'Covered By Your Grace', 'Crafty Girls', 'Creepster', 'Crete Round', 'Crimson Text', 'Croissant One', 'Crushed', 'Cuprum', 'Cutive', 'Cutive Mono', 'Damion', 'Dancing Script', 'Dangrek', 'Dawning of a New Day', 'Days One', 'Dekko', 'Delius', 'Delius Swash Caps', 'Delius Unicase', 'Della Respira', 'Denk One', 'Devonshire', 'Dhurjati', 'Didact Gothic', 'Diplomata', 'Diplomata SC', 'Domine', 'Donegal One', 'Doppio One', 'Dorsa', 'Dosis', 'Dr Sugiyama', 'Droid Sans', 'Droid Sans Mono', 'Droid Serif', 'Duru Sans', 'Dynalight', 'EB Garamond', 'Eagle Lake', 'Eater', 'Economica', 'Ek Mukta', 'Electrolize', 'Elsie', 'Elsie Swash Caps', 'Emblema One', 'Emilys Candy', 'Engagement', 'Englebert', 'Enriqueta', 'Erica One', 'Esteban', 'Euphoria Script', 'Ewert', 'Exo', 'Exo 2', 'Expletus Sans', 'Fanwood Text', 'Fascinate', 'Fascinate Inline', 'Faster One', 'Fasthand', 'Fauna One', 'Federant', 'Federo', 'Felipa', 'Fenix', 'Finger Paint', 'Fira Mono', 'Fira Sans', 'Fjalla One', 'Fjord One', 'Flamenco', 'Flavors', 'Fondamento', 'Fontdiner Swanky', 'Forum', 'Francois One', 'Freckle Face', 'Fredericka the Great', 'Fredoka One', 'Freehand', 'Fresca', 'Frijole', 'Fruktur', 'Fugaz One', 'GFS Didot', 'GFS Neohellenic', 'Gabriela', 'Gafata', 'Galdeano', 'Galindo', 'Gentium Basic', 'Gentium Book Basic', 'Geo', 'Geostar', 'Geostar Fill', 'Germania One', 'Gidugu', 'Gilda Display', 'Give You Glory', 'Glass Antiqua', 'Glegoo', 'Gloria Hallelujah', 'Goblin One', 'Gochi Hand', 'Gorditas', 'Goudy Bookletter 1911', 'Graduate', 'Grand Hotel', 'Gravitas One', 'Great Vibes', 'Griffy', 'Gruppo', 'Gudea', 'Gurajada', 'Habibi', 'Halant', 'Hammersmith One', 'Hanalei', 'Hanalei Fill', 'Handlee', 'Hanuman', 'Happy Monkey', 'Headland One', 'Henny Penny', 'Herr Von Muellerhoff', 'Hind', 'Holtwood One SC', 'Homemade Apple', 'Homenaje', 'IM Fell DW Pica', 'IM Fell DW Pica SC', 'IM Fell Double Pica', 'IM Fell Double Pica SC', 'IM Fell English', 'IM Fell English SC', 'IM Fell French Canon', 'IM Fell French Canon SC', 'IM Fell Great Primer', 'IM Fell Great Primer SC', 'Iceberg', 'Iceland', 'Imprima', 'Inconsolata', 'Inder', 'Indie Flower', 'Inika', 'Irish Grover', 'Istok Web', 'Italiana', 'Italianno', 'Jacques Francois', 'Jacques Francois Shadow', 'Jaldi', 'Jim Nightshade', 'Jockey One', 'Jolly Lodger', 'Josefin Sans', 'Josefin Slab', 'Joti One', 'Judson', 'Julee', 'Julius Sans One', 'Junge', 'Jura', 'Just Another Hand', 'Just Me Again Down Here', 'Kalam', 'Kameron', 'Kantumruy', 'Karla', 'Karma', 'Kaushan Script', 'Kavoon', 'Kdam Thmor', 'Keania One', 'Kelly Slab', 'Kenia', 'Khand', 'Khmer', 'Khula', 'Kite One', 'Knewave', 'Kotta One', 'Koulen', 'Kranky', 'Kreon', 'Kristi', 'Krona One', 'Kurale', 'La Belle Aurore', 'Laila', 'Lakki Reddy', 'Lancelot', 'Lateef', 'Lato', 'League Script', 'Leckerli One', 'Ledger', 'Lekton', 'Lemon', 'Libre Baskerville', 'Life Savers', 'Lilita One', 'Lily Script One', 'Limelight', 'Linden Hill', 'Lobster', 'Lobster Two', 'Londrina Outline', 'Londrina Shadow', 'Londrina Sketch', 'Londrina Solid', 'Lora', 'Love Ya Like A Sister', 'Loved by the King', 'Lovers Quarrel', 'Luckiest Guy', 'Lusitana', 'Lustria', 'Macondo', 'Macondo Swash Caps', 'Magra', 'Maiden Orange', 'Mako', 'Mallanna', 'Mandali', 'Marcellus', 'Marcellus SC', 'Marck Script', 'Margarine', 'Marko One', 'Marmelad', 'Martel', 'Martel Sans', 'Marvel', 'Mate', 'Mate SC', 'Maven Pro', 'McLaren', 'Meddon', 'MedievalSharp', 'Medula One', 'Megrim', 'Meie Script', 'Merienda', 'Merienda One', 'Merriweather', 'Merriweather Sans', 'Metal', 'Metal Mania', 'Metamorphous', 'Metrophobic', 'Michroma', 'Milonga', 'Miltonian', 'Miltonian Tattoo', 'Miniver', 'Miss Fajardose', 'Modak', 'Modern Antiqua', 'Molengo', 'Monda', 'Monofett', 'Monoton', 'Monsieur La Doulaise', 'Montaga', 'Montez', 'Montserrat', 'Montserrat Alternates', 'Montserrat Subrayada', 'Moul', 'Moulpali', 'Mountains of Christmas', 'Mouse Memoirs', 'Mr Bedfort', 'Mr Dafoe', 'Mr De Haviland', 'Mrs Saint Delafield', 'Mrs Sheppards', 'Muli', 'Mystery Quest', 'NTR', 'Neucha', 'Neuton', 'New Rocker', 'News Cycle', 'Niconne', 'Nixie One', 'Nobile', 'Nokora', 'Norican', 'Nosifer', 'Nothing You Could Do', 'Noticia Text', 'Noto Sans', 'Noto Serif', 'Nova Cut', 'Nova Flat', 'Nova Mono', 'Nova Oval', 'Nova Round', 'Nova Script', 'Nova Slim', 'Nova Square', 'Numans', 'Nunito', 'Odor Mean Chey', 'Offside', 'Old Standard TT', 'Oldenburg', 'Oleo Script', 'Oleo Script Swash Caps', 'Open Sans', 'Oranienbaum', 'Orbitron', 'Oregano', 'Orienta', 'Original Surfer', 'Oswald', 'Over the Rainbow', 'Overlock', 'Overlock SC', 'Ovo', 'Oxygen', 'Oxygen Mono', 'PT Mono', 'PT Sans', 'PT Sans Caption', 'PT Sans Narrow', 'PT Serif', 'PT Serif Caption', 'Pacifico', 'Palanquin', 'Palanquin Dark', 'Paprika', 'Parisienne', 'Passero One', 'Passion One', 'Pathway Gothic One', 'Patrick Hand', 'Patrick Hand SC', 'Patua One', 'Paytone One', 'Peddana', 'Peralta', 'Permanent Marker', 'Petit Formal Script', 'Petrona', 'Philosopher', 'Piedra', 'Pinyon Script', 'Pirata One', 'Plaster', 'Play', 'Playball', 'Playfair Display', 'Playfair Display SC', 'Podkova', 'Poiret One', 'Poller One', 'Poly', 'Pompiere', 'Pontano Sans', 'Port Lligat Sans', 'Port Lligat Slab', 'Pragati Narrow', 'Prata', 'Preahvihear', 'Press Start 2P', 'Princess Sofia', 'Prociono', 'Prosto One', 'Puritan', 'Purple Purse', 'Quando', 'Quantico', 'Quattrocento', 'Quattrocento Sans', 'Questrial', 'Quicksand', 'Quintessential', 'Qwigley', 'Racing Sans One', 'Radley', 'Rajdhani', 'Raleway', 'Raleway Dots', 'Ramabhadra', 'Ramaraja', 'Rambla', 'Rammetto One', 'Ranchers', 'Rancho', 'Ranga', 'Rationale', 'Ravi Prakash', 'Redressed', 'Reenie Beanie', 'Revalia', 'Ribeye', 'Ribeye Marrow', 'Righteous', 'Risque', 'Roboto', 'Roboto Condensed', 'Roboto Slab', 'Rochester', 'Rock Salt', 'Rokkitt', 'Romanesco', 'Ropa Sans', 'Rosario', 'Rosarivo', 'Rouge Script', 'Rozha One', 'Rubik Mono One', 'Rubik One', 'Ruda', 'Rufina', 'Ruge Boogie', 'Ruluko', 'Rum Raisin', 'Ruslan Display', 'Russo One', 'Ruthie', 'Rye', 'Sacramento', 'Sail', 'Salsa', 'Sanchez', 'Sancreek', 'Sansita One', 'Sarina', 'Sarpanch', 'Satisfy', 'Scada', 'Scheherazade', 'Schoolbell', 'Seaweed Script', 'Sevillana', 'Seymour One', 'Shadows Into Light', 'Shadows Into Light Two', 'Shanti', 'Share', 'Share Tech', 'Share Tech Mono', 'Shojumaru', 'Short Stack', 'Siemreap', 'Sigmar One', 'Signika', 'Signika Negative', 'Simonetta', 'Sintony', 'Sirin Stencil', 'Six Caps', 'Skranji', 'Slabo 13px', 'Slabo 27px', 'Slackey', 'Smokum', 'Smythe', 'Sniglet', 'Snippet', 'Snowburst One', 'Sofadi One', 'Sofia', 'Sonsie One', 'Sorts Mill Goudy', 'Source Code Pro', 'Source Sans Pro', 'Source Serif Pro', 'Special Elite', 'Spicy Rice', 'Spinnaker', 'Spirax', 'Squada One', 'Sree Krushnadevaraya', 'Stalemate', 'Stalinist One', 'Stardos Stencil', 'Stint Ultra Condensed', 'Stint Ultra Expanded', 'Stoke', 'Strait', 'Sue Ellen Francisco', 'Sumana', 'Sunshiney', 'Supermercado One', 'Suranna', 'Suravaram', 'Suwannaphum', 'Swanky and Moo Moo', 'Syncopate', 'Tangerine', 'Taprom', 'Tauri', 'Teko', 'Telex', 'Tenali Ramakrishna', 'Tenor Sans', 'Text Me One', 'The Girl Next Door', 'Tienne', 'Timmana', 'Tinos', 'Titan One', 'Titillium Web', 'Trade Winds', 'Trocchi', 'Trochut', 'Trykker', 'Tulpen One', 'Ubuntu', 'Ubuntu Condensed', 'Ubuntu Mono', 'Ultra', 'Uncial Antiqua', 'Underdog', 'Unica One', 'UnifrakturMaguntia', 'Unkempt', 'Unlock', 'Unna', 'VT323', 'Vampiro One', 'Varela', 'Varela Round', 'Vast Shadow', 'Vesper Libre', 'Vibur', 'Vidaloka', 'Viga', 'Voces', 'Volkhov', 'Vollkorn', 'Voltaire', 'Waiting for the Sunrise', 'Wallpoet', 'Walter Turncoat', 'Warnes', 'Wellfleet', 'Wendy One', 'Wire One', 'Yanone Kaffeesatz', 'Yellowtail', 'Yeseva One', 'Yesteryear', 'Zeyada');
	}
	public function getStandardFontsList() {
		return array('Georgia', 'Palatino Linotype', 'Times New Roman', 'Arial', 'Helvetica', 'Arial Black', 'Gadget', 'Comic Sans MS', 'Impact', 'Charcoal', 'Lucida Sans Unicode', 'Lucida Grande', 'Tahoma', 'Geneva', 'Trebuchet MS', 'Verdana', 'Geneva', 'Courier New', 'Courier', 'Lucida Console', 'Monaco');
	}
	public function getAllFontsList() {
		$fontsList = array_merge($this->getFontsList(), $this->getStandardFontsList());
		natsort($fontsList);
		array_unshift($fontsList, $this->defaultFont);
		$options = array();
		foreach ($fontsList as $font) {
			$options[$font] = $font;
		}
		return $options;
	}
	public function getFontStyles() {
		return array('' => '', 'n' => 'normal', 'b' => 'bold', 'i' => 'italic', 'bi' => 'bold + italic');
	}
	public function getBorderStyles() {
		return array('' => '', 'solid' => 'solid', 'dashed' => 'dashed', 'dotted' => 'dotted', 'double' => 'double');
	}

	/**
	 * Extend free version logic for filter.
	 *
	 * @return array
	 */
	public function getAttrFilterLogicPro( $logic ) {
		$logic['display']['not_in'] = 'Not In';
		$logic['loop']['not_in'] = 'NOT IN';
		$logic['delimetr']['not_in'] = ';';

		return $logic;
	}

	/**
	 * Get options filter variant list with collapsible option activated.
	 *
	 * @return array
	 */
	public function getCollapsibleFiltreOptions() {
		$collapsible = array(
			'multi',
			'list'
		);

		return $collapsible;
	}
}
