(function ($, app) {
"use strict";
	$(document).ready(function() {
		var WpfFrontendPage = window.wpfFrontendPage;

		function wpfEventsFrontendPro() {
			//Price Filter
			jQuery('.wpfFilterWrapper[data-filter-type="wpfPrice"]').each(function () {
				WpfFrontendPage.initIonSlider(jQuery(this));
			});
			jQuery('.wpfPriceRangeCustom input').on('change', function(e) {
				e.preventDefault();
				var li = jQuery(this).closest('li');
				li.attr('data-range', li.find('input[name="wpf_custom_min"]').val() + ',' + li.find('input[name="wpf_custom_max"]').val());
			});
			jQuery('.wpfPriceRangeCustom i').on('click', function(e) {
				e.preventDefault();
				var $this = jQuery(this),
					wrapper = $this.closest('.wpfFilterWrapper');
				wrapper.find('.wpfFilterContent .wpfCheckbox input').prop('checked', false);
				$this.closest('li').find('.wpfCheckbox input').prop('checked', true);
				wrapper.removeClass('wpfNotActive');
				WpfFrontendPage.setSelectedParamsPro(wrapper);

				WpfFrontendPage.filtering($this.closest('.wpfMainWrapper'));
			});
			jQuery('.wpfFilterWrapper .wpfSearchWrapper button').on('click', function (e) {
				e.preventDefault();
				var wrapper = jQuery(this).closest('.wpfFilterWrapper');
				if (wrapper.find('.wpfSearchFieldsFilter').val() == '') {
					WpfFrontendPage.clearFilters(wrapper);
				} else {
					wrapper.removeClass('wpfNotActive');
					wrapper.find('.wpfFilterContent li:not(.wpfSearchHidden) .wpfCheckbox input').prop('checked', true);
					WpfFrontendPage.setSelectedParamsPro(wrapper);
				}
				WpfFrontendPage.filtering(wrapper.closest('.wpfMainWrapper'));
			});

			//Category Filter
			jQuery('.wpfFilterWrapper[data-collapsible="1"]').each(function() {
				var categoryFilter = jQuery(this);
				categoryFilter.find('.wpfCollapsible').on('click', function (e) {
					e.preventDefault();
					var $this = $(this),
						parentLi = $this.closest('li');

					if($this.html() == '+') {
						parentLi.children('ul').removeClass('wpfHidden');
						$this.html('-');
					} else {
						var uls = parentLi.find('ul');
						uls.addClass('wpfHidden');
						parentLi.find('.wpfCollapsible').html('+');
					}
					return;
				});
				categoryFilter.find('.wpfCollapsible').each(function() {
					if($(this).closest('li').find('ul input:checked').length) {
						$(this).trigger('click');
					}
				});
			});

			//Rating Filter
			if(jQuery('.wpfFilterWrapper .wpfStarsRating').length) {
				var starFilter = jQuery('.wpfFilterWrapper .wpfStarsRating');
				if(starFilter.attr('data-display-type') == 'linestars') {
					var	starColor = starFilter.attr('data-star-color'),
						leerColor = starFilter.attr('data-leer-color'),
						addText = starFilter.attr('data-add-text'),
						addText5 = starFilter.attr('data-add-text5');
					starFilter.find('input.wpfStarInput').on('change',function() {
						var checkedItem = starFilter.find('input.wpfStarInput:checked');
						starFilter.find('.wpfStarsAdditional').text(checkedItem.length && checkedItem.attr('id') == 'wpfLineStar5' ? addText5 : addText);
					});

				} else {
					starFilter.find('input.wpfStarInput').on('change',function() {
						starFilter.find('.wpfStarsRatingBlock').removeClass('wpfLineChecked');
						starFilter.find('input.wpfStarInput:checked').closest('.wpfStarsRatingBlock').addClass('wpfLineChecked');
					});
				}
				starFilter.show();
			}

			//SearchText Filter
			var searchTextFilter = jQuery('.wpfFilterWrapper[data-filter-type="wpfSearchText"]');
			if(searchTextFilter) {
				if(searchTextFilter.attr('data-autocomplete') == '1') {
					var input = searchTextFilter.find('input');
					input.autocomplete({
						source: function (request, response) {
							var autocomleate = [];
							jQuery.sendFormWpf({
								data: {
									mod: 'woofilterpro',
									action: 'autocompliteSearchText',
									value: input.val()
								},
								onSuccess: function(result) {
									if(!result.error && result.data && result.data.words) {
										var data = result.data.words;
										for(var i = 0; i <= data.length; i++) {
											autocomleate.push({label: data[i], value: data[i]});
										}
									}
									response(autocomleate);
								}
							});
						},
						select: function(event, ui) {
							WpfFrontendPage.eventChangeFilter(event);
						},
						minLength: 2,
						delay: 10
					});

				}
				searchTextFilter.find('button').on('click', function (e) {
					e.preventDefault();
					WpfFrontendPage.eventChangeFilter(e);
				});
				searchTextFilter.find('input').keypress(function(e) {
					if(e.keyCode == 13) {
						e.preventDefault();
						WpfFrontendPage.eventChangeFilter(e);
					}
				});
			}

			//Attribute Filter
			jQuery('.wpfFilterWrapper .wpfColorsFilterHor label.icon').tooltipster().attr('title', '');
			jQuery('.wpfFilterWrapper .wpfColorsFilter label.icon').each(function(){
					jQuery(this).css('color', wpfGetColorText(jQuery(this).css('background-color')));
			});
			jQuery('.wpfFilterWrapper[data-filter-type="wpfAttribute"][data-display-type="slider"]').each(function () {
				var skin = jQuery(this).attr('data-price-skin');
				if (skin === 'default') {
					WpfFrontendPage.initDefaultSlider(jQuery(this), 'attr');
				} else {
					WpfFrontendPage.initIonSlider(jQuery(this), 'attr');
				}
			});

			// Buttons/text-type filters
			jQuery('.wpfButtonsFilter input, .wpfTextFilter input').on('change', function(e){
				var input = jQuery(this),
					wrapper = input.closest('li');
				if(input.is(':checked')) wrapper.addClass('wpfTermChecked');
				else wrapper.removeClass('wpfTermChecked');
			});
			jQuery('.wpfButtonsFilter li').on('click', function(e){
				if(jQuery(this).hasClass('wpfOptionDisabled')) return false;
				var input = jQuery(this).find('input');
				input.prop('checked', !input.is(':checked')).trigger('change');
			});
			jQuery('.wpfTextFilter input:checked').each(function(){
				jQuery(this).closest('li').addClass('wpfTermChecked');
			});

			jQuery('.wpfMainWrapper').each(function () {
				var mainWrapper = jQuery(this),
					settings = WpfFrontendPage.getFilterMainSettings(mainWrapper),
					hideButton = mainWrapper.find('.wfpHideButton');
				// Selected Parameters
				if(settings && settings.settings.display_selected_params === '1') {
					var wrapper = jQuery('<div class="wpfSelectedParameters"></div>');
					WpfFrontendPage.selectedParamsColor = wpfLightenDarkenColor(mainWrapper.css('background-color'), -10);
					mainWrapper.find('.wpfFilterWrapper:not(.wpfNotActive):not(.wpfHidden)').each(function () {
						var filter = jQuery(this),
							filterType = filter.attr('data-filter-type'),
							filterName = filter.attr('data-get-attribute'),
							filterLogic = filter.attr('data-query-logic'),
							params = WpfFrontendPage.getFilterOptionsByType(filter, filterType);
							params = WpfFrontendPage.filterParamByParentPro(settings, params);
						WpfFrontendPage.addSelectedParamsPro(wrapper, params, filterType, filterName, filterLogic);
					});

					if(settings.settings.selected_params_clear === '1') {
						wrapper.append(jQuery('<div class="wpfSelectedParametersClear">Clear All</div>'));
					}
					if(wrapper.find('.wpfSelectedParameter').length == 0) wrapper.addClass('wpfHidden');
					if(settings.settings.selected_params_position === 'bottom') mainWrapper.append(wrapper);
					else if(hideButton.length) wrapper.insertAfter(hideButton);
					else mainWrapper.prepend(wrapper);
				}
				mainWrapper.find('.wpfFilterWrapper').each(function() {
					var wrapper = jQuery(this);

					//ABC index
					if(wrapper.attr('data-abc') == '1') {
						wrapper.find('.wpfFilterVerScroll').each(function() {
							var abc = '',
								verBlock = jQuery(this);
							verBlock.children('li[data-parent="0"]').each(function(){
								var li = jQuery(this),
									name = li.find('.wpfValue').html(),
									letter = name.substr((name.substring(0, 1) == '<' ? name.indexOf('>') + 1 : 0), 1).toUpperCase();

								if(abc.indexOf(letter) == -1) {
									jQuery('<li class="wpfAbcLetter" data-letter="'+letter+'">'+letter+'</li>').insertBefore(li);
									abc += '<div class="wpfAbcLink" data-letter="'+letter+'">'+letter+'</div>';
								}
								li.attr('data-letter', letter);
							});
							if(abc != '') jQuery('<div class="wpfAbcToggle">Alphabetical index</div><div class="wpfAbcLinks wpfHidden">'+abc+'</div>').insertBefore(verBlock);
						});
						WpfFrontendPage.wpfShowHideFiltersAttsPro(wrapper);
					}

					// Show More 
					wrapper.find('.wpfFilterVerScroll').each(function () {
						WpfFrontendPage.initShowMore(jQuery(this));
					});
				});
				if(hideButton.length && hideButton.attr('data-is-open') === '0') {
					hideButton.siblings('div:not(.wpfPreviewLoader):not(.wpfLoaderLayout)').addClass('wpfHideFilter');
				} 
			});
			jQuery('.wpfMainWrapper .wpfAbcToggle').on('click', function(e){
				e.preventDefault();
				var wrapper = jQuery(this).closest('.wpfFilterWrapper').find('.wpfAbcLinks');
				if(wrapper.hasClass('wpfHidden')) wrapper.removeClass('wpfHidden');
				else wrapper.addClass('wpfHidden');
			});
			jQuery('.wpfMainWrapper .wpfAbcLink').on('click', function(e){
				e.preventDefault();
				var link = jQuery(this),
					wrapper = link.closest('.wpfFilterWrapper').find('.wpfFilterVerScroll'),
					letter = wrapper.find('.wpfAbcLetter[data-letter="'+link.attr('data-letter')+'"]:first');
				if(letter.hasClass('wpfMoreHidden')) wrapper.find('.wpfShowMoreWrapper').trigger('click');
				//wrapper.find('.wpfAbcLetter[data-letter="'+link.attr('data-letter')+'"]').get(0).scrollIntoView(true);
				//wrapper.scrollTo(wrapper.find('.wpfAbcLetter[data-letter="'+link.attr('data-letter')+'"]'));
				wrapper.stop().animate({
    				scrollTop: wrapper.find('.wpfAbcLetter[data-letter="'+link.attr('data-letter')+'"]:first').offset().top-wrapper.find('li:first').offset().top
  				}, 500);
				//wrapper.scrollTo('.wpfAbcLetter[data-letter="'+link.attr('data-letter')+'"]', 1000);
			});

			jQuery('body').off('click', '.wpfShowMoreWrapper').on('click', '.wpfShowMoreWrapper', function() {
				var more = jQuery(this),
					block = more.closest('.wpfFilterVerScroll').attr('data-open-more', 1);
				if (more.attr('data-full-opening') == '1') block.css({'maxHeight': 'none'});

				block.find('li').removeClass('wpfMoreHidden');
				more.remove();
				block.append(jQuery('<li class="wpfShowFewerWrapper"> - Show Fewer </li>'));
			});
			jQuery('body').off('click', '.wpfShowFewerWrapper').on('click', '.wpfShowFewerWrapper', function() {
				WpfFrontendPage.initShowMore(jQuery(this).closest('.wpfFilterVerScroll').attr('data-open-more', 0));
			});

			jQuery('body').off('click', '.wpfSelectedParameters .wpfSelectedDelete').on('click', '.wpfSelectedParameters .wpfSelectedDelete',  function(e){
				e.preventDefault();
				var param = jQuery(this).closest('.wpfSelectedParameter'),
					paramName = param.attr('data-filter-name'),
					paramType = param.attr('data-filter-type'),
					mainWrapper = param.closest('.wpfMainWrapper');
				if(param.attr('data-is-one') == '1') {
					WpfFrontendPage.clearFilters(mainWrapper.find('.wpfFilterWrapper[data-filter-type="'+paramType+'"]'));
					WpfFrontendPage.filtering(mainWrapper);
				} else {
					mainWrapper.find('.wpfFilterWrapper[data-filter-type="'+paramType+'"][data-get-attribute="'+paramName+'"]').each(function() {
						var filter = jQuery(this);
						if(filter.attr('data-display-type') == 'mul_dropdown') {
							filter.find('option[data-term-id="'+param.attr('data-key')+'"]').removeAttr('selected').trigger('change');
	                    	filter.find('select.jqmsLoaded').multiselect('reload');
                		} else {
							var input = filter.find('[data-term-id="'+param.attr('data-key')+'"]');
							if(input.length && !input.is('input')) input = input.find('input');
							if(input.length) input.prop('checked', false).trigger('change');
						}
					});
				}
			});
			jQuery('body').off('click', '.wpfSelectedParameters .wpfSelectedParametersClear').on('click', '.wpfSelectedParameters .wpfSelectedParametersClear',  function(e){
				e.preventDefault();
				var $filterWrapper = jQuery(this).closest('.wpfMainWrapper');
				WpfFrontendPage.clearFilters($filterWrapper.find('.wpfFilterWrapper'), true);
				WpfFrontendPage.filtering($filterWrapper);
			});

			// Hide button
			jQuery('body').off('click', '.wfpHideButton').on('click', '.wfpHideButton',  function(e){
				e.preventDefault();
				var button = jQuery(this),
					icon = button.find('i'),
					txt = button.find('.wfpHideText'),
					up = 'fa-chevron-up',
					down = 'fa-chevron-down';
				if(icon.hasClass(up)) {
					icon.removeClass(up).addClass(down);
					txt.html(button.attr('data-show-text'));
					button.siblings('div:not(.wpfPreviewLoader):not(.wpfLoaderLayout)').addClass('wpfHideFilter');
				} else {
					icon.removeClass(down).addClass(up);
					txt.html(button.attr('data-hide-text'));
					button.siblings('div').removeClass('wpfHideFilter');
				}
			});
			
			//change price filters
			jQuery('.wpfFilterWrapper[data-filter-type="wpfAttribute"][data-display-type="slider"]').on('wpfAttrSliderChange', function(event){
				var filter = jQuery(this);
				
				filter.removeClass('wpfNotActive');
			});
		}

		WpfFrontendPage.constructor.prototype.eventsFrontendPro = (function () {
			wpfEventsFrontendPro();
		});
		
		WpfFrontendPage.constructor.prototype.initIonSlider = (function (filter, type) {
			var mainWrapper = filter.closest('.wpfMainWrapper'),
				autoFilteringEnable = (mainWrapper.find('.wpfFilterButton').length == 0),
				decimal = filter.attr('data-decimal'),
				step = filter.attr('data-step'),
				minInputId = '#wpfMinPrice',
				maxInputId = '#wpfMaxPrice',
				triggerName = 'wpfPriceChange',
				filterType = typeof type !== 'undefined' ? type : 'price';
			
			if (filterType === 'attr') {
				minInputId = '#wpfMinAttrNum';
				maxInputId = '#wpfMaxAttrNum';
				triggerName = 'wpfAttrSliderChange';
			}
			
			if(filter.find('.ion-range-slider').length) {
				filter.find('.ion-range-slider').ionRangeSlider({
					onStart: function (data) {
						var irsGrid = data.input.siblings('.irs').find('.irs-grid'),
							irsGridTexts = irsGrid.find('.irs-grid-text');
						irsGridTexts.each(function(){
							var tVal = parseFloat(jQuery(this).text()).toFixed(decimal);
							jQuery(this).text(tVal);
						});
					},
					onChange:  function (data) {
						filter.find(minInputId).val(data.from.toFixed(decimal));
						filter.find(maxInputId).val(data.to.toFixed(decimal));
						data.step = Number(step);
						filter.trigger(triggerName);
					},
					onFinish: function (data) {
						filter.removeClass('wpfNotActive');
						if(autoFilteringEnable){
							WpfFrontendPage.filtering(mainWrapper);
						}
						data.step = Number(step);
						filter.trigger(triggerName);
					}
					
				});
				var slider = filter.find('.ion-range-slider').data('ionRangeSlider');
				
				filter.find('input').on('blur', function (e) {
					slider.update({from: filter.find(minInputId).val(), to: filter.find(maxInputId).val()});
				});
			}
		});

		WpfFrontendPage.constructor.prototype.initShowMore = (function(verBlock) {
			if (verBlock.length == 0) return;
			var isOpen = verBlock.attr('data-open-more');
			if (isOpen == '1') return;

			var settings = WpfFrontendPage.getFilterMainSettings(verBlock.closest('.wpfMainWrapper'));
			if(settings && settings.settings.display_view_more === '1' && !settings.settings.display_items_in_a_row) {
				verBlock.attr('data-open-more', 0);
				verBlock.css({'maxHeight': ''}).find('li').removeClass('wpfMoreHidden');
				verBlock.find('.wpfShowMoreWrapper').remove();
				verBlock.find('.wpfShowFewerWrapper').remove();
				
				verBlock.scrollTop(0);
				var verObj = verBlock.get(0);
				if(verObj.scrollHeight > verObj.clientHeight) {
					var viewHeigth = verObj.clientHeight,
						rectBlock = verObj.getBoundingClientRect(),
						findHidden = false,
						lastVisible = false;
					verBlock.find('li').each(function () {
						var li = jQuery(this),
							rect = this.getBoundingClientRect();

						if(rect.height > 0) {
							var mTop = parseInt(li.css('margin-top')),
								mBottom = parseInt(li.css('margin-bottom'));
							if(findHidden || rect.top - (mTop < 0 ? mTop : 0) < rectBlock.top || rect.bottom - (mBottom < 0 ? mBottom : 0) > rectBlock.bottom) {
								li.addClass('wpfMoreHidden');
								findHidden = true;
							} else if (!findHidden) {
								lastVisible = li;
							}
						}
					});
					if(findHidden && lastVisible) {
						var more = jQuery('<li class="wpfShowMoreWrapper"> + Show More </li>');
						if(settings.settings.view_more_full == '1') {
							more.attr('data-full-opening', 1);
						}
						more.insertBefore(lastVisible);
						lastVisible.addClass('wpfMoreHidden');
					}
				}
			}
		});

		WpfFrontendPage.constructor.prototype.addSelectedParamsPro = (function (wrapper, params, filterType, filterName, filterLogic) {
			if(!wrapper || !('selected' in params)) return;

			var selected = params['selected'],
				isOne = 'is_one' in selected && selected['is_one'] ? 1 : 0,
				current = wrapper.find('.wpfSelectedParameter[data-filter-type="'+filterType+'"][data-filter-name="'+filterName+'"]'),
				clear = wrapper.find('.wpfSelectedParametersClear'),
				list = 'list' in selected && selected['list'],
				curLen = current.length;
			if(curLen) {
				if((isOne && curLen > 1) || list.length == 0) {
					current.remove();
					current = [];
				}
				else current.attr('data-delete', 1);
			}
			for(var key in list) {
				var found = current.length ? current.filter('[data-key="'+key+'"]') : false;
				if(found && found.length) {
					found.find('.wpfSelectedTitle').html(list[key]);
					found.removeAttr('data-delete');
				}
				else {
					var obj = jQuery(
						'<div class="wpfSelectedParameter" data-filter-type="'+ filterType +
						'" data-filter-name="' + filterName +
						'" data-query-logic="' + filterLogic +
						'" data-is-one="' + isOne +
						'" data-key="' + key +
						'"></div>');
					obj.append(jQuery('<div class="wpfSelectedDelete">x</div>'));
					obj.append(jQuery('<div class="wpfSelectedTitle">' + list[key] + '</div>'));
					obj.css('background-color', WpfFrontendPage.selectedParamsColor);
					if(clear.length) obj.insertBefore(clear);
					else wrapper.append(obj);
				}
			}
			if(current.length) current.filter('[data-delete]').remove();
			if(wrapper.find('.wpfSelectedParameter').length == 0) wrapper.addClass('wpfHidden');
			else wrapper.removeClass('wpfHidden');
		});

		WpfFrontendPage.constructor.prototype.setSelectedParamsPro = (function (filter, settings) {
			if(!filter.hasClass('wpfFilterWrapper')) filter = filter.closest('.wpfFilterWrapper');
			if(filter.length == 0) return;

			if(typeof settings == 'undefined') settings = WpfFrontendPage.getFilterMainSettings(filter.closest('.wpfMainWrapper'));
			if(!settings || settings.settings.display_selected_params !== '1') return;

			var filterType = filter.attr('data-filter-type'),
                filterName = filter.attr('data-get-attribute'),
                filterLogic = filter.attr('data-query-logic'),
                params = filter.hasClass('wpfNotActive') || filter.hasClass('wpfHidden') ? {'selected': {'is_one': true, 'list': []}} : WpfFrontendPage.getFilterOptionsByType(filter, filterType),
                wrapper = filter.closest('.wpfMainWrapper').find('.wpfSelectedParameters');
                params = WpfFrontendPage.filterParamByParentPro(settings, params);
			WpfFrontendPage.addSelectedParamsPro(wrapper, params, filterType, filterName, filterLogic);
		});

		WpfFrontendPage.constructor.prototype.eventChangeFilterPro = (function (filter, settings) {
			WpfFrontendPage.setSelectedParamsPro(filter, settings);
		});

		WpfFrontendPage.constructor.prototype.changeUrlByFilterParamsPro = (function ($filtersDataFrontend, noWooPage, filterWrapper) {
			var _thisObj = this.$obj;
			switch ($filtersDataFrontend['id']) {
				case 'wpfSearchText':
                    var value = $filtersDataFrontend['settings']['value'],
                        attr = $filtersDataFrontend['settings']['attribute'];
                    if (typeof value !== 'undefined' && value.length > 0 ) {
                        _thisObj.QStringWork(attr, value, noWooPage, filterWrapper, 'change');
                    }else{
                        _thisObj.QStringWork(attr, '', noWooPage, filterWrapper, 'remove');
                    }
					break;
				case 'wpfBrand':
                    var product_brand = $filtersDataFrontend['settings']['settings'],
                        name = 'product_brand';

                    product_brand = product_brand.join(',');
                    if (typeof product_brand !== 'undefined' && product_brand.length > 0) {
                        _thisObj.QStringWork(name, product_brand, noWooPage, filterWrapper, 'change');
                    }else{
                        _thisObj.QStringWork(name, '', noWooPage, filterWrapper, 'remove');
                    }
					break;
				default:
					break;
			}

			return;
		});

		WpfFrontendPage.constructor.prototype.clearFiltersPro = (function ($filter) {
			if($filter.find('.ion-range-slider').length) {
				var slider = $filter.find('.ion-range-slider').data('ionRangeSlider');
				slider.update({from: slider.options.min, to: slider.options.max});
			}
			if($filter.attr('data-display-type') == 'linestars') {
				$filter.find('.wpfStarsAdditional').text($filter.find('.wpfStarsRating').attr('data-add-text'));
			} else {
				$filter.find('.wpfStarsRatingBlock').removeClass('wpfLineChecked');
			}
			$filter.find('.wpfTermChecked').removeClass('wpfTermChecked');
			$filter.find('.wpfPriceRangeCustom input').val('');
			$filter.find('.wpfPriceRangeCustom').closest('li').attr('data-range', '');
			if($filter.attr('data-display-type') == 'slider') {
				var min = $filter.find('#wpfMinAttrNum').attr('min'),
					max = $filter.find('#wpfMaxAttrNum').attr('max');
				$filter.find('#wpfMinAttrNum').val(min);
				$filter.find('#wpfMaxAttrNum').val(max);
			}
			return;
		});

		WpfFrontendPage.constructor.prototype.getSearchTextFilterOptions = (function ($filter) {
			var optionsArray = [],
				value = $filter.find('input').val(),
				options = {
					attribute: $filter.attr('data-get-attribute'),
					value: value,
					fullword: $filter.attr('data-full-word'),
					excluded: JSON.parse($filter.attr('data-excluded'))
				};

			//options for backend (filtering)
			optionsArray['backend'] = options;

			//options for frontend(change url)
			optionsArray['frontend'] = options;
			optionsArray['selected'] = {'is_one': true, 'list': (value == '' ? [] : [value])};
			return optionsArray;
		});

        WpfFrontendPage.constructor.prototype.getBrandFilterOptions = (function ($filter) {
            var _thisObj = this.$obj,
            	optionsArray = [],
            	frontendOptions = [],
            	options = [],
            	filterType = $filter.attr('data-display-type'),
            	selectedOptions = {'is_one': (filterType != 'mul_dropdown'), 'list': []},
            	withCount = $filter.hasClass('wpfShowCount'),
            	i = 0;

            //options for backend (filtering)
            if(filterType === 'list'){
                $filter.find('input:checked').each(function () {
                	var li = jQuery(this).closest('li'),
						id = li.attr('data-term-id');
					options[i] = id;
					frontendOptions[i] = li.attr('data-term-slug');
					selectedOptions['list'][id] = li.find('.wpfValue').html();
					i++;
                });
            }else if(filterType === 'dropdown'){
            	var option = $filter.find(":selected"),
					value = option.val();
				options[i] = value;
				if(value != '') {
					frontendOptions[i] = option.attr('data-slug');
					selectedOptions['list'][option.attr('data-term-id')] = _thisObj.getClearLabel(option.html(), withCount);
				}
            }else if(filterType === 'mul_dropdown'){
                $filter.find(':selected').each(function () {
                	var option = jQuery(this);
					options[i] = option.val();
					frontendOptions[i] = option.attr('data-slug');
					selectedOptions['list'][option.attr('data-term-id')] = _thisObj.getClearLabel(option.html(), withCount);
					i++;
                });
            }
            optionsArray['backend'] = options;

            //options for frontend(change url)
            var getParams = $filter.attr('data-get-attribute');

            optionsArray['frontend'] = [];
            optionsArray['frontend']['taxonomy'] = getParams;
            optionsArray['frontend']['settings'] = frontendOptions;
            optionsArray['selected'] = selectedOptions;

            return optionsArray;
        });

		WpfFrontendPage.constructor.prototype.wpfShowHideFiltersAttsPro = (function(filter) {
			filter.find('li').removeClass('wpfMoreHidden');
			var links = filter.find('.wpfAbcLink');
			if(links.length) {
				links.each(function(){
					var link = jQuery(this),
						letter = link.attr('data-letter'),
						anchor = filter.find('.wpfAbcLetter[data-letter="'+letter+'"]');
					if(filter.find('li[data-term-id][data-letter="'+letter+'"]:visible').length) {
						link.removeClass('wpfHidden');
						anchor.removeClass('wpfHidden');
					}
					else {
						link.addClass('wpfHidden');
						anchor.addClass('wpfHidden');
					}
				});
				links.removeClass('wpfAbcLinkFirst').filter(':not(.wpfHidden):first').addClass('wpfAbcLinkFirst');
			}
			filter.find('.wpfFilterVerScroll').each(function () {
				WpfFrontendPage.initShowMore(jQuery(this));
			});
		});

		WpfFrontendPage.constructor.prototype.filterParamByParentPro = (function(settings, params) {

			if (settings.settings.expand_selected_to_child === '0') {
				if (typeof params.selected.removeSelected !== 'undefined' && typeof params.selected.list !== 'undefined') {
					var selectedList = params.selected.list,
						removeSelected = params.selected.removeSelected;

					for (var selectedtId in selectedList) {
						if ( removeSelected.indexOf(parseInt(selectedtId)) !== -1 ) {
							delete selectedList[selectedtId];
						}
					}

					params.selected.list = selectedList;
				}
			}

			return params;
		});

		WpfFrontendPage.eventsFrontendPro();

	});

}(window.jQuery));
