(function( $ ) {
	var iconListToggles = [
		'.et-core-control-toggle',
		'.et-fb-form__toggle[data-name="button"]',
		'.et-fb-form__toggle[data-name="button_one"]',
		'.et-fb-form__toggle[data-name="button_two"]',
		'.et-fb-form__toggle[data-name="image"]',
		'.et-fb-form__toggle[data-name="overlay"]',
	];
  
  var iconFilters =
  '<div id="dikg_icon_filter" class="dikg_icon_filter dikg_icon_filter--closed">' +
    '<span class="dikg_icon_filter__btn dikg_icon_filter--visible">Search Icons</span>' +
		'<div class="dikg_icon_filter__controls dikg_icon_filter--hidden">' +
		  '<div class="dikg_icon_filter__control_option_holder"></div>' +
      '<span class="dikg_icon_filter__control_option dikg_icon_filter__control_option--inactive dikg_icon_filter__control_action dikg_icon_filter__all">All</span>' +
      '<span class="dikg_icon_filter__control_option dikg_icon_filter__control_option--inactive dikg_icon_filter__control_action dikg_icon_filter__close">Close</span>' +
    '</div>' +
  '</div>';

	var iconFontList           = '.et-fb-font-icon-list';
	var builder_frame_selector = 'et-fb-app-frame';
	iconListToggles            = iconListToggles.join();

	$(function(){
		$(document).on('click',iconListToggles, function(){

			if( $('#dikg_icon_filter').length < 1 ) {
				
        $.ajax({
				  type     : "POST",
				  url      : ajax_params.ajax_url,
				  cache    : false,
          dataType : 'JSON',
				  data: {
					  action : 'vb_fetch_icons_dikg',
					  nonce  : ajax_params.nonce
				  }
			  })
			  .fail(function( jqXHR, textStatus, errorThrown ){
				  //console.log( jqXHR.responseText );
			  })
			  .done(function( data, textStatus, jqXHR ){

					$( iconFilters ).insertAfter( iconFontList );

					var $iconList = $( iconFontList ).find('li'),
					familyList = [];
          
				  $.each(data, function(i,v){

						$( $iconList[i] ).attr('data-name', v.name);
						$( $iconList[i] ).attr('data-terms', v.terms);
						$( $iconList[i] ).attr('data-style', v.style);
						$( $iconList[i] ).attr('data-family', v.family);
						$( $iconList[i] ).attr('title', v.name + ' (' + v.family + ')');

						if( $.inArray( v.family, familyList ) === -1 ) {
							familyList.push( v.family );
						}
					});

					// Add family filter.
					if( familyList.length > 0 ) {
						$.each( familyList, function(){
							$('#dikg_icon_filter').find('.dikg_icon_filter__control_option_holder').append(
                '<span class="dikg_icon_filter__control_option dikg_icon_filter__control_family" data-value="' + this + '">' + this + '</span>'
							);
						});
					}
				});
			}
		});
	});
})( jQuery );